/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.subr;

import java.math.BigInteger;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispReal;
import net.morilib.lisp.nano.subr.BinaryArgs;

public class Modulo
extends BinaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
        if (c1a instanceof LispReal && c2a instanceof LispReal) {
            LispReal r1 = (LispReal)c1a;
            LispReal r2 = (LispReal)c2a;
            if (r2.signum() == 0) {
                throw mesg.getError("err.divbyzero");
            }
            if (r1.isInteger() && r2.isInteger()) {
                BigInteger a = r1.getBigInteger();
                BigInteger b = r2.getBigInteger();
                BigInteger r = b.compareTo(BigInteger.ZERO) > 0 ? a.mod(b) : b.add(a.mod(b.abs()));
                if (r1.isExact() && r2.isExact()) {
                    return LispInteger.valueOf(r);
                }
                return new LispDouble(r.doubleValue());
            }
            if (!r1.isInteger()) {
                throw mesg.getError("err.require.int", r1);
            }
            throw mesg.getError("err.require.int", r2);
        }
        if (!(c1a instanceof LispReal)) {
            throw mesg.getError("err.require.int", c1a);
        }
        throw mesg.getError("err.require.int", c2a);
    }
}

