/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.nano.subr;

import java.util.List;
import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispSmallInt;
import net.morilib.lisp.nano.LispString;
import net.morilib.lisp.nano.LispUtils;
import net.morilib.lisp.nano.Subr;

public class Substring
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() != 3) {
            throw mesg.getError("err.argument", this.symbolName);
        }
        if (!(lst.get(0) instanceof LispString)) {
            throw mesg.getError("err.require.string", lst.get(0));
        }
        if (!(lst.get(1) instanceof LispSmallInt)) {
            throw mesg.getError("err.require.smallint", lst.get(1));
        }
        if (!(lst.get(2) instanceof LispSmallInt)) {
            throw mesg.getError("err.require.smallint", lst.get(2));
        }
        String str = ((LispString)lst.get(0)).getString();
        int inds = ((LispSmallInt)lst.get(1)).getExactSmallInt();
        int inde = ((LispSmallInt)lst.get(2)).getExactSmallInt();
        if (inds < 0 || inds >= str.length()) {
            throw mesg.getError("err.string.outofrange", lst.get(1));
        }
        if (inde < 0 || inde > str.length()) {
            throw mesg.getError("err.string.outofrange", lst.get(2));
        }
        if (inde < inds) {
            return new LispString("");
        }
        return new LispString(str.substring(inds, inde));
    }
}

