/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAState;
import net.morilib.math.stochastic.StochasticProcess;
import net.morilib.nina.NinaAction;
import net.morilib.nina.NinaEvent;
import net.morilib.nina.NinaException;
import net.morilib.nina.NinaFrameReader;
import net.morilib.nina.NinaParser;
import net.morilib.nina.NinaSubautomata;
import net.morilib.range.CharSets;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.util.Tuple2;

public class MarkovChainBuilder
implements NinaAction {
    private static final Pattern PTN1 = Pattern.compile("[\t\n ]*'(.*)'[\t\n ]*");
    private static final Pattern PTN2 = Pattern.compile("[\t\n ]*\\[(.*)\\][\t\n ]*");
    private DBS initial;
    private DBS vertex;
    private String label;
    private String name;

    private Object parseOutput(String s) {
        Matcher m = PTN1.matcher(s);
        if (m.matches()) {
            String t = m.group(1);
            t = t.replaceAll("\\n", "\n");
            t = t.replaceAll("\\r", "\r");
            t = t.replaceAll("\\t", "\t");
            return t;
        }
        m = PTN2.matcher(s);
        if (m.matches()) {
            String t = m.group(1);
            Range r = CharSets.parse(t);
            if (r.contains(0x7FFFFFFE)) {
                throw new NinaException("complement is not available", new Object[0]);
            }
            ArrayList<Integer> l = new ArrayList<Integer>();
            for (Interval v : r.intervals()) {
                int k = (Integer)v.getInfimumBound();
                while (v.contains(k)) {
                    l.add(k);
                    ++k;
                }
            }
            return l;
        }
        return s.trim();
    }

    @Override
    public void labelAdded(NinaEvent q, NinaFrameReader rd, boolean accept) {
        int l;
        StringWriter wr = new StringWriter();
        char[] a = new char[1024];
        while ((l = rd.read(a)) >= 0) {
            wr.write(a, 0, l);
        }
        if (this.vertex == null) {
            this.initial = this.vertex = this.createState(q);
        }
        this.vertex.output = this.parseOutput(wr.toString());
        this.vertex.accepted = accept;
    }

    @Override
    public void link(NinaEvent q, Object ver) {
        DBS v = this.vertex;
        this.vertex = ver != null ? (DBS)ver : this.createState(q);
        v.linkAlphabet(this.vertex, Double.valueOf(q.getEdge().toString()));
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public Object getVertex() {
        return this.vertex;
    }

    @Override
    public void setVertex(Object o) {
        this.vertex = (DBS)o;
    }

    @Override
    public void doneBlockSearching(NinaEvent q) {
        this.vertex = (DBS)q.getScratch();
    }

    @Override
    public void setEdge(NinaEvent q, Object o) {
        q.setEdge(o);
    }

    @Override
    public void setEdgeCharSequence(NinaEvent q, CharSequence o, int qc) {
        throw new NinaException("cannotaddcharsequence", new Object[0]);
    }

    @Override
    public void setEdgeResource(NinaEvent q, NinaParser p, String s, Map<String, String> map, NinaSubautomata sub) {
        throw new NinaException("cannotaddnfa", new Object[0]);
    }

    @Override
    public void setEdgeNFA(NinaEvent q, NinaParser p, NFA<Object, NFAState, Void> s) {
        throw new NinaException("cannotaddnfa", new Object[0]);
    }

    @Override
    public void setEdgeEnd(NinaEvent q) {
        throw new NinaException("endtransitionerror", "Markov chain");
    }

    @Override
    public NinaAction accept(String name) {
        this.name = name;
        return this;
    }

    @Override
    public StochasticProcess getMachine() {
        return this.initial;
    }

    @Override
    public void setMealyEdge(int c) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setMealyEdge(Object o) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setPriority(int p) {
    }

    @Override
    public void putStateByLabel(String l, Object s) {
    }

    @Override
    public Object getStateByLabel(String l) {
        return null;
    }

    @Override
    public String getLabelByState(Object s) {
        return null;
    }

    @Override
    public Object getDeadState() {
        return this.getStateByLabel("D");
    }

    @Override
    public DBS createState(NinaEvent q) {
        DBS s = new DBS();
        return s;
    }

    @Override
    public void setStartState(Object o) {
        this.initial = this.vertex = (DBS)o;
    }

    @Override
    public void setUserEdge(NinaEvent q, String o) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public Set<String> getLabels() {
        return Collections.emptySet();
    }

    @Override
    public void putTypeByLabel(String l, String s) {
    }

    @Override
    public String getTypeByLabel(String l) {
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setEdgeSequence(NinaEvent q, Range r, int len) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setMealyEdgeType(int c) {
    }

    @Override
    public void setAccept(boolean accept) {
        this.vertex.accepted = accept;
    }

    @Override
    public void setEdgeDynamic(NinaEvent q, String var) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public Map<String, String> getDynamicTransitMap() {
        return Collections.emptyMap();
    }

    @Override
    public void setEdgeGrammar(NinaEvent q, String name) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setEdgeRepeatedResource(NinaEvent q, String s, Object d) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public NinaAction empty(NinaEvent q, String name) {
        this.setStartState(this.createState(q));
        return this.accept(name);
    }

    @Override
    public void setEdgeDigits(NinaEvent q, int digits, boolean sign) {
        throw new NinaException("isnotfa", new Object[0]);
    }

    @Override
    public void setEdgeHexadecimal(NinaEvent q, int bits) {
        throw new NinaException("isnotfa", new Object[0]);
    }

    @Override
    public void setEdgeOctal(NinaEvent q, int bits) {
        throw new NinaException("isnotfa", new Object[0]);
    }

    @Override
    public void setEdgeFloat(NinaEvent q) {
        throw new NinaException("isnotfa", new Object[0]);
    }

    @Override
    public void setEdgeIndent(NinaEvent q, String cmp, int off) {
        throw new NinaException("isnotdfa", new Object[0]);
    }

    @Override
    public void setEdgeIdentifier(NinaEvent q, String lang) {
        throw new NinaException("isnotfa", new Object[0]);
    }

    static class DBS
    implements StochasticProcess {
        List<Tuple2<Number, DBS>> edges = new ArrayList<Tuple2<Number, DBS>>();
        boolean accepted;
        Object output;
        double sum;

        DBS() {
        }

        void linkAlphabet(DBS d, Number o) {
            this.edges.add(new Tuple2<Number, DBS>(o, d));
            this.sum += o.doubleValue();
        }

        @Override
        public DBS go(double r) {
            double l = 0.0;
            DBS x = null;
            for (Tuple2<Number, DBS> e : this.edges) {
                double v = e.getA().doubleValue() / this.sum;
                x = e.getB();
                if (r > l && r <= l + v) {
                    return x;
                }
                l += v;
            }
            return x;
        }

        @Override
        public boolean isDead() {
            return this.edges.isEmpty();
        }

        @Override
        public boolean isAccepted() {
            return this.accepted;
        }

        @Override
        public Object getOutput() {
            if (this.output instanceof String) {
                return this.output;
            }
            if (this.output instanceof List) {
                List l = (List)this.output;
                int k = (int)((double)l.size() * Math.random());
                StringBuffer b = new StringBuffer();
                b.appendCodePoint((Integer)l.get(k));
                return b.toString();
            }
            return "";
        }
    }
}

