/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina;

import java.util.HashSet;
import java.util.Set;
import net.morilib.range.Interval;
import net.morilib.range.Range;
import net.morilib.range.RangeAdder;
import net.morilib.util.IntervalMap;

public class NinaMap<T, V> {
    private IntervalMap<V> map = new IntervalMap();
    private Set<V> eps = new HashSet<V>();

    NinaMap() {
    }

    void put(T key, V value) {
        if (key == null) {
            this.eps.add(value);
        } else {
            this.map.put(Interval.newPoint(key), value);
        }
    }

    void put(Range key, V value) {
        if (key == null || key.isEmpty()) {
            this.eps.add(value);
        } else {
            for (Interval a : key.intervals()) {
                this.map.put(a, value);
            }
        }
    }

    public Set<V> get(T key) {
        if (key != null) {
            return this.map.get(Interval.newPoint(key));
        }
        return this.eps;
    }

    public Set<V> get(Range r) {
        HashSet<V> s = new HashSet<V>();
        if (r != null) {
            for (Interval v : r.intervals()) {
                s.addAll(this.map.get(v));
            }
            return s;
        }
        return this.eps;
    }

    public Range getKeyRange() {
        RangeAdder a = new RangeAdder();
        for (Interval e : this.map.keySet()) {
            a.addInterval(e);
        }
        return a.toRange();
    }

    public Set<T> getDiscreteKeys() {
        HashSet<Object> r = new HashSet<Object>();
        for (Interval e : this.map.keySet()) {
            int i;
            Object b;
            Object a = e.getInfimumBound();
            if (a.equals(b = e.getSupremumBound())) {
                r.add(a);
                continue;
            }
            if (a instanceof Character) {
                int ac;
                i = ac = ((Character)a).charValue();
                while (e.contains(i)) {
                    r.add(i);
                    ++i;
                }
                continue;
            }
            if (a instanceof Integer) {
                int ai;
                i = ai = ((Integer)a).intValue();
                while (e.contains(i)) {
                    r.add(i);
                    ++i;
                }
                continue;
            }
            throw new ClassCastException();
        }
        return r;
    }

    public Set<V> valueSet() {
        HashSet<V> r = new HashSet<V>();
        for (Interval v : this.map.keySet()) {
            r.addAll(this.map.get(v));
        }
        return r;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        String d = "";
        for (Interval v : this.map.keySet()) {
            b.append(d).append("<<").append(v);
            b.append(" , ").append(this.map.get(v)).append(">>");
            d = "\n";
        }
        return b.toString();
    }
}

