/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.lint;

import net.morilib.nina.lint.LintCells;

public abstract class LintCell {
    private int character;
    private int x;
    private int y;
    private LintCells cells;
    boolean error = false;

    public LintCell(LintCells cells, int ch, int x, int y) {
        this.cells = cells;
        this.character = ch;
        this.x = x;
        this.y = y;
    }

    protected void addWarning(String msg, Object ... args) {
        this.cells.addWarning(msg, args);
    }

    public abstract boolean isPath();

    public abstract boolean isFrame();

    public abstract boolean isAlphabet();

    public abstract boolean isBlank();

    public abstract void validate();

    public int getCharacter() {
        return this.character;
    }

    public int getX() {
        return this.x + 1;
    }

    public int getY() {
        return this.y + 1 + this.cells.getYOffset();
    }

    public LintCell north() {
        return this.cells.get(this.x, this.y - 1);
    }

    public LintCell south() {
        return this.cells.get(this.x, this.y + 1);
    }

    public LintCell west() {
        return this.cells.get(this.x - 1, this.y);
    }

    public LintCell east() {
        return this.cells.get(this.x + 1, this.y);
    }

    public boolean isError() {
        return this.error;
    }

    public String toString() {
        char[] a = new char[]{(char)this.character};
        return new String(a);
    }
}

