/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.automata.DFAState;
import net.morilib.nina.DFABuilder;
import net.morilib.nina.NinaException;
import net.morilib.nina.NinaState;
import net.morilib.nina.Quadro;
import net.morilib.nina.TMBuilder;
import net.morilib.nina.translate.AbstractNinaTranslator;
import net.morilib.nina.translate.LRTranslator;
import net.morilib.nina.translate.LRTranslatorC;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.ReplaceAction;
import net.morilib.nina.translate.ReplaceActionCSharp;
import net.morilib.nina.translate.sh.ReplaceStrangeChar;
import net.morilib.range.Interval;
import net.morilib.sh.ShEnvironment;

public class NinaTranslatorC
extends AbstractNinaTranslator {
    private static final Pattern RET_CONST = Pattern.compile("return +([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*;");
    private static final Pattern _IAT = Pattern.compile("(.*),([A-Z]+|\\*)");
    private static final String LOK = "LOOKAHEAD($c);";
    private boolean[] _usesignal = new boolean[16];

    public NinaTranslatorC() {
        this.parent = this;
    }

    private int infimumbound(Interval a) {
        Object o = a.getInfimumBound();
        return o == Interval.FROM_INFIMUM ? 0 : (Integer)o;
    }

    private int getDeadStateNo() {
        Object s = this.builder.getDeadState();
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    private int getStateNoByLabel(String l) {
        Object s = this.builder.getStateByLabel(l);
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    private String tostr(int c) {
        String x = c == 92 ? "'\\\\'" : (c == 10 ? "'\\n'" : (c == 39 ? "'\\''" : (Character.isISOControl(c) ? Integer.toString(c) : (c < 65535 ? String.format("'%c'", Character.valueOf((char)c)) : Integer.toString(c)))));
        return x;
    }

    private boolean isLookahead(Object o) {
        return o != null && o.toString().startsWith(LOK);
    }

    private void printintv(PrintStream out, Interval v, boolean els, Object o) {
        String z;
        String s = v.isInfimumClosed() ? ">=" : ">";
        String t = v.isSupremumClosed() ? "<=" : "<";
        String a = els ? "\t\t} else if" : "\t\tif";
        int c = (Integer)v.getInfimumBound();
        int d = (Integer)v.getSupremumBound();
        String x = this.tostr(c);
        String y = this.tostr(d);
        String string = z = o != null && o.toString().startsWith(LOK) ? "__l__ && " : "";
        if (v.isClosed() && c == d) {
            out.format("%s(%s__c__ == %s) {\n", a, z, x);
        } else {
            out.format("%s(%s__c__ %s %s && __c__ %s %s) {\n", a, z, s, x, t, y);
        }
    }

    private String outln(boolean els, PrintStream out, String s) {
        if (els) {
            out.printf("\t\t\t} else if(%s) {\n", s);
        } else {
            out.printf("\t\t\tif(%s) {\n", s);
        }
        return "\t";
    }

    private void printNextStep(PrintStream out, DFAState<Object, ?, Void> d) {
        out.format("\t\t\t__this__->state = %d;\n", this.getStateNo(d));
        out.println("\t\t\treturn 1;");
    }

    private boolean printDynamicTransition(PrintStream out, DFAState<Object, ?, Void> dfa, boolean els) {
        DFABuilder.DBS d;
        if (dfa instanceof DFABuilder.DBS && (d = ((DFABuilder.DBS)dfa).getDynamic()) != null) {
            String s = ((DFABuilder.DBS)dfa).getDynamicVariable();
            out.print("\t\t");
            if (els) {
                out.print("} else ");
            }
            out.printf("if(__l__ && DYNAMIC_STARTWITH(%s, __c__)) {\n", s);
            out.format("\t\t\tINIT_DYNAMIC(__this__, %s, %d);\n", s, this.getStateNo(dfa));
            out.format("\t\t\t__stk_push_C(__this__, %d, dynamic);\n", this.getStateNo(d));
            out.format("\t\t\t__this__->state = 0;\n", s);
            out.format("\t\t\treturn NINA_ACCEPT;\n", s);
            return true;
        }
        return els;
    }

    private void printWritetape(PrintStream out, String a) {
        if (a.length() != 0) {
            if (a.length() > 1) {
                out.printf("\t\t\t\t_writetape(\"%s\");\n", a);
            } else if (a.charAt(0) == '\\' || a.charAt(0) == '\'') {
                out.printf("\t\t\t\t_writetape('\\%c');\n", Character.valueOf(a.charAt(0)));
            } else {
                out.printf("\t\t\t\t_writetape('%c');\n", Character.valueOf(a.charAt(0)));
            }
        }
    }

    private void printIntervalAction(PrintStream out, DFAState<Object, ?, Void> d, Object o) {
        boolean[] z = new boolean[1];
        if (d instanceof TMBuilder.DBS) {
            if (o == null) {
                out.printf("\t\t\t\t_movetape(R);\n", new Object[0]);
            } else {
                String s = o.toString();
                if (!s.equals("UNGET($c);")) {
                    Matcher m = _IAT.matcher(s);
                    if (m.matches()) {
                        this.printWritetape(out, m.group(1));
                        if (!m.group(2).equals("*")) {
                            out.printf("\t\t\t\t_movetape(%s);\n", m.group(2));
                        }
                    } else {
                        this.printWritetape(out, s);
                    }
                }
            }
        } else if (o != null) {
            out.format("\t\t\t\t%s\n", ReplaceAction.replace(o.toString(), z, this, this.getStateNo(d), this.builder.getLabelByState(d)));
        }
    }

    private void printState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        Set<String> k;
        TMBuilder.DBS x;
        DFABuilder.DBS b;
        Object o;
        int c;
        boolean els = false;
        int sn = this.getStateNo(dfa);
        out.format("\tcase %d:\n", sn);
        if (dfa instanceof DFABuilder.DBS && ((DFABuilder.DBS)dfa).isOnlyEmptyTransition()) {
            out.format("\t\t__this__->state = %d;\n", this.getStateNo(((DFABuilder.DBS)dfa).getOthers()));
            out.println("\t\treturn 1;");
            return;
        }
        for (Interval interval : dfa.getAlphabetRanges()) {
            if (interval.isEmpty()) continue;
            c = this.infimumbound(interval);
            if (interval.isInfimumOpen()) {
                ++c;
            }
            if (!this.isLookahead(o = dfa.getLabelInt(c))) continue;
            o = dfa.getLabelInt(c);
            this.printintv(out, interval, els, o);
            this.printIntervalAction(out, dfa, o);
            this.printNextStep(out, dfa.goInt(c));
            els = true;
        }
        for (Interval interval : dfa.getAlphabetRanges()) {
            if (interval.isEmpty()) continue;
            c = this.infimumbound(interval);
            if (interval.isInfimumOpen()) {
                ++c;
            }
            if (this.isLookahead(o = dfa.getLabelInt(c))) continue;
            o = dfa.getLabelInt(c);
            this.printintv(out, interval, els, o);
            this.printIntervalAction(out, dfa, o);
            this.printNextStep(out, dfa.goInt(c));
            els = true;
        }
        els = this.printDynamicTransition(out, dfa, els);
        if (dfa instanceof DFABuilder.DBS && (b = ((DFABuilder.DBS)dfa).getEnd()) != null) {
            this.outln(els, out, "__c__ < 0");
            this.printIntervalAction(out, dfa, ((DFABuilder.DBS)dfa).getMealyEnd());
            out.format("\t\t\t\t__this__->state = %d;\n", this.getStateNo(b));
            out.format("\t\t\t\treturn 1;\n", new Object[0]);
            els = true;
        } else if (dfa instanceof TMBuilder.DBS && (x = ((TMBuilder.DBS)dfa).getEnd()) != null) {
            this.outln(els, out, "__c__ < 0");
            this.printIntervalAction(out, dfa, ((TMBuilder.DBS)dfa).getMealyEnd());
            out.format("\t\t\t\t__this__->state = %d;\n", this.getStateNo(x));
            out.format("\t\t\t\treturn 1;\n", new Object[0]);
            els = true;
        }
        if (dfa instanceof DFABuilder.DBS && (k = ((DFABuilder.DBS)dfa).getUserEdges()) != null) {
            for (String string : k) {
                b = ((DFABuilder.DBS)dfa).getUserEdge(string);
                o = ((DFABuilder.DBS)dfa).getUserMealyEdge(string);
                if (els) {
                    out.printf("\t\t} else if(%s) {\n", string);
                } else {
                    out.printf("\t\tif(%s) {\n", string);
                }
                this.printIntervalAction(out, dfa, o);
                out.format("\t\t\t__this__->state = %d;\n", this.getStateNo(b));
                out.format("\t\t\treturn 1;\n", new Object[0]);
                els = true;
            }
        }
        if (dfa instanceof TMBuilder.DBS) {
            x = ((TMBuilder.DBS)dfa).getOthers();
            if (x != null) {
                String s = this.outln(els, out, "__c__ >= 0");
                this.printIntervalAction(out, dfa, ((TMBuilder.DBS)dfa).getMealyOthers());
                out.format("%s\t\t\t__this__->state = %d;\n", s, this.getStateNo(x));
                out.format("%s\t\t\treturn 1;\n", s);
                els = true;
            }
        } else if (dfa instanceof DFABuilder.DBS) {
            DFABuilder.DBS a = (DFABuilder.DBS)dfa;
            b = a.getOthers();
            if (b != null) {
                String s = this.outln(els, out, "__c__ >= 0");
                this.printIntervalAction(out, dfa, a.getMealyOthers());
                out.format("%s\t\t\t__this__->state = %d;\n", s, this.getStateNo(b));
                out.format("%s\t\t\treturn 1;\n", s);
                els = true;
            } else {
                b = a.getRecursive();
                if (b != null) {
                    if (a.getRecursiveName().startsWith("g:")) {
                        String s = this.outln(els, out, "__c__ >= 0");
                        String t = a.getRecursiveName().substring(2);
                        out.format("%s\t\t\t__stk_push_C(__this__, %d, _LR_%s);\n", s, this.getStateNo(b), t);
                        out.format("%s\t\t\t__this__->state = 0;\n", s);
                        out.format("%s\t\t\t__this__->__synptr = NULL;\n", s);
                        out.format("%s\t\t\treturn NINA_ACCEPT;\n", s);
                        els = true;
                    } else {
                        String s = this.outln(els, out, "__c__ >= 0");
                        out.format("%s\t\t\t__stk_push_C(__this__, %d, %s);\n", s, this.getStateNo(b), ReplaceStrangeChar.replace(a.getRecursiveName()));
                        out.format("%s\t\t\t__this__->state = 0;\n", s);
                        out.format("%s\t\t\treturn NINA_ACCEPT;\n", s);
                        els = true;
                    }
                }
            }
        }
        if (els) {
            out.println("\t\t\t}");
        }
        out.println("\t\treturn 0;");
    }

    private boolean isProcessed(DFAState<Object, ?, Void> state) {
        return this.containsState(state);
    }

    @Override
    public void printStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printState(out, this.popStack());
            }
        }
    }

    @Override
    public void printObjectStates(PrintStream out) {
        throw new NinaException("unsupportedobjecttype", "C");
    }

    @Override
    public void printClassStates(PrintStream out) {
        throw new NinaException("unsupportedclasstype", "C");
    }

    private void printPStates(PrintStream out, Set<Integer> a) {
        String d = "\treturn (";
        if (a.size() == 0) {
            out.println("\treturn 0;");
        } else {
            for (Integer i : a) {
                out.print(d);
                out.format("__this__->state == %d", i);
                d = " ||\n\t\t\t";
            }
            out.println(");");
        }
    }

    @Override
    public void printAcceptStates(PrintStream out) {
        this.printPStates(out, this.acceptsIterable());
    }

    @Override
    public void printDeadStates(PrintStream out) {
        this.printPStates(out, this.deadsIterable());
    }

    @Override
    public void printEmptyTransitionStates(PrintStream out) {
        this.printPStates(out, this.emptyTransitionsIterable());
    }

    @Override
    public void printAcceptToken(PrintStream out) {
        boolean[] z = new boolean[1];
        int m = -1;
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!s.isAccepted()) continue;
            String p = null;
            m = -1;
            out.format("\tcase %d:\n", this.stateNo(s));
            for (Object a : s.getAccepted()) {
                int q;
                if (a == null || !(a instanceof NinaState) || (q = ((NinaState)a).getPriority()) < 0 || q <= m) continue;
                m = q;
            }
            for (Object a : s.getAccepted()) {
                NinaState n;
                String x;
                if (a == null || !(a instanceof NinaState) || (x = (n = (NinaState)a).getLabel()) == null || (x = x.trim()).equals("")) continue;
                if (m >= 0) {
                    if (n.getPriority() != m) continue;
                    p = x;
                    continue;
                }
                if (RET_CONST.matcher(x).matches()) {
                    p = x;
                    break;
                }
                if (p != null) {
                    this.getOptions().pwarn("ambiguousaccept", new Object[0]);
                }
                p = x;
            }
            p = p != null ? ReplaceAction.replace(p, z, this, this.getStateNo(s), this.builder.getLabelByState(s)) : "return __b__;";
            out.format("\t\t%s\n", p);
        }
    }

    @Override
    public void printActions(PrintStream out) {
        boolean[] a = new boolean[1];
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            String p = null;
            out.format("\tcase %d:\n", this.stateNo(s));
            String x = s.toString();
            if (x != null && !(x = x.trim()).equals("")) {
                p = x;
            }
            if (p == null) {
                out.println("\t\tbreak;");
                continue;
            }
            p = ReplaceAction.replace(p, a, this, this.stateNo(s), this.builder.getLabelByState(s));
            String[] stringArray = p.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                out.format("\t\t%s\n", v);
                ++n2;
            }
            if (a[0]) continue;
            out.println("\t\tbreak;");
        }
    }

    @Override
    public void printImports(List<String> imp, PrintStream out) {
    }

    @Override
    public void printIsEnd(PrintStream out) {
        HashSet<Integer> t = new HashSet<Integer>();
        String d = "\treturn (";
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!(s instanceof DFABuilder.DBS) || ((DFABuilder.DBS)s).getEnd() == null) continue;
            t.add(this.stateNo(s));
        }
        if (t.size() == 0) {
            out.println("\treturn 0;");
        } else {
            for (Integer i : t) {
                out.print(d);
                out.format("__this__->state == %d", i);
                d = " ||\n\t";
            }
            out.println(");");
        }
    }

    @Override
    public void printDeadState(String n, PrintStream out) {
        out.printf("\treturn %d;\n", this.getDeadStateNo());
    }

    private int signo(String s) {
        if (s == null) {
            return -1;
        }
        if (s.equals("SIGHUP")) {
            return 1;
        }
        if (s.equals("SIGINT")) {
            return 2;
        }
        if (s.equals("SIGQUIT")) {
            return 3;
        }
        if (s.equals("SIGILL")) {
            return 4;
        }
        if (s.equals("SIGABRT")) {
            return 6;
        }
        if (s.equals("SIGFPE")) {
            return 8;
        }
        if (s.equals("SIGSEGV")) {
            return 11;
        }
        if (s.equals("SIGPIPE")) {
            return 13;
        }
        if (s.equals("SIGALRM")) {
            return 14;
        }
        if (s.equals("SIGTERM")) {
            return 15;
        }
        return -1;
    }

    @Override
    protected void printRecover(PrintStream out) {
        String d = "";
        for (String x : this.builder.getLabels()) {
            int n = this.signo(x);
            if (n < 0) continue;
            ((NinaTranslatorC)this.parent)._usesignal[n] = true;
            DFAState s = (DFAState)this.builder.getStateByLabel(x);
            out.printf("\t%sif(e == %d) {\n", d, n);
            out.printf("\t\treturn %d;\n", this.getStateNo(s));
            d = "} else ";
        }
        if (d.equals("")) {
            out.println("\treturn -1;");
        } else {
            out.println("\t} else {");
            out.println("\t\treturn -1;");
            out.println("\t}");
        }
    }

    @Override
    public void printFinallyState(PrintStream out) {
        out.printf("\treturn %d;\n", this.getStateNoByLabel("finally"));
    }

    @Override
    protected void printInitTrap(PrintStream out) {
        int k = 1;
        while (k < this._usesignal.length) {
            if (((NinaTranslatorC)this.parent)._usesignal[k]) {
                out.printf("\tsignal(%d, __nina_signal);\n", k);
            }
            ++k;
        }
    }

    @Override
    protected void printNFADeadState(PrintStream out) {
        out.print("return (0");
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!s.isDead()) continue;
            out.print(" || ");
            out.print("__this__->state == ");
            out.print(this.stateNo(s));
        }
        out.println(");");
    }

    @Override
    protected void printAttrs(PrintStream out) {
        boolean b = true;
        for (String x : this.builder.getLabels()) {
            String t;
            if (x == null || x.equals("") || (t = this.builder.getTypeByLabel(x)) == null || t.equals("")) continue;
            b = false;
            out.printf("\t\t%s %s;\n", t, x);
        }
        if (b) {
            out.println("\t\tchar __dummy__;");
        }
    }

    @Override
    protected void printConstants(PrintStream out) {
        for (Map.Entry<String, Integer> t : this.quadro.getConstantMap().entrySet()) {
            out.printf("#define %s %d\n", t.getKey(), (int)t.getValue());
        }
    }

    @Override
    public void reportStatistics(PrintStream std) {
        this.getOptions().print("statheader", new Object[0]);
        this.getOptions().print("statstates", this.stateSize());
        this.getOptions().print("stataccept", this.acceptsSize());
    }

    @Override
    protected InputStream openScript(ShEnvironment env) {
        return NinaTranslator.class.getResourceAsStream("/net/morilib/nina/translate/nina_template." + this.getMachine() + ".c.sh");
    }

    @Override
    public String getExtension() {
        return ".c";
    }

    @Override
    protected PrintStream openOutput() throws IOException {
        Object s = this.getOptions().getOutputDir();
        return new PrintStream(this.getOptions().getOutputStream(s, String.valueOf(this.getOptions().getOutputFilename()) + this.getExtension()), true);
    }

    @Override
    protected AbstractNinaTranslator newPrototype() {
        NinaTranslatorC r = new NinaTranslatorC();
        r.quadro = this.quadro;
        return r;
    }

    @Override
    protected void appendValue(StringBuffer ot, StringBuffer b1) {
        String l = b1.toString();
        Object o = this.builder.getStateByLabel(l);
        String t = this.builder.getTypeByLabel(l);
        if (l.equals("c")) {
            ot.append("__c__");
        } else if (l.equals("this")) {
            ot.append("(((struct ");
            ot.append(this.options.getFilename());
            ot.append("_tag *)__this__)->__user_fields)");
        } else if (o == null) {
            ot.append('$');
            ot.append(b1);
        } else if (t == null) {
            ot.append('$');
            ot.append(b1);
        } else {
            ot.append("(__stv_C(__this__)).");
            ot.append(this.builder.getName());
            ot.append(".");
            ot.append(b1);
        }
    }

    @Override
    protected void appendLvalue(StringBuffer ot, StringBuffer b1) {
        Object o = this.builder.getStateByLabel(b1.toString());
        if (o == null) {
            ot.append('@');
            ot.append(b1);
        } else {
            ot.append("(__stv_C(__this__)).");
            ot.append(this.builder.getName());
            ot.append(".");
            ot.append(b1);
        }
    }

    @Override
    protected void appendMyPosition(StringBuffer ot, String ln, int cn) {
        ot.append("(__stv_C(__this__)).");
        ot.append(this.builder.getName());
        ot.append(".");
        ot.append(ln);
    }

    @Override
    protected void appendReturn(StringBuffer ot) {
        ot.append("__b__");
    }

    @Override
    protected String getConstName(String t) {
        if (t.equals("EXIT")) {
            return "NINA_ACCEPT";
        }
        if (t.equals("FAIL")) {
            return "NINA_FAIL";
        }
        if (t.equals("ACCEPT")) {
            return "NINA_HALT_ACCEPT";
        }
        if (t.equals("REJECT")) {
            return "NINA_HALT_REJECT";
        }
        return null;
    }

    @Override
    protected void appendYield(StringBuffer ot, String b) {
        ot.append("__this__->yieldobject = (");
        ot.append(ReplaceActionCSharp.replace(b)).append(");");
        ot.append("return NINA_YIELD;");
    }

    @Override
    protected LRTranslator getLRTranslator(Quadro q) {
        return new LRTranslatorC(q);
    }

    @Override
    protected void setLocalenv(Quadro q, ShEnvironment env) {
        env.bind("VALTYPE", q.getOptionNvl("valtype", "int"));
    }
}

