/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.nina.translate;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.morilib.automata.DFAState;
import net.morilib.nina.DFABuilder;
import net.morilib.nina.NinaState;
import net.morilib.nina.Quadro;
import net.morilib.nina.TMBuilder;
import net.morilib.nina.translate.AbstractNinaTranslator;
import net.morilib.nina.translate.LRTranslator;
import net.morilib.nina.translate.LRTranslatorCSharp;
import net.morilib.nina.translate.NinaTranslator;
import net.morilib.nina.translate.ReplaceAction;
import net.morilib.nina.translate.ReplaceActionCSharp;
import net.morilib.nina.translate.sh.ReplaceStrangeChar;
import net.morilib.range.Interval;
import net.morilib.sh.ShEnvironment;

public class NinaTranslatorCSharp
extends AbstractNinaTranslator {
    private static final Pattern RET_CONST = Pattern.compile("return +([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*;");
    private static final Pattern E_CONST = Pattern.compile("([A-Za-z][A-Za-z0-9]*\\.)*[A-Z][A-Z0-9]*");
    private static final Pattern _IAT = Pattern.compile("(.*),([A-Z]+|\\*)");
    private static final Pattern _CLS = Pattern.compile("<(.*)>");
    private static final Pattern _STR = Pattern.compile("\"(.*)\"");
    private static final String LOK = "__this__.LOOKAHEAD($c);";

    public NinaTranslatorCSharp() {
        this.parent = this;
    }

    private int infimumbound(Interval a) {
        Object o = a.getInfimumBound();
        return o == Interval.FROM_INFIMUM ? 0 : (Integer)o;
    }

    private String tostr(int c) {
        String x = c == 92 ? "'\\\\'" : (c == 10 ? "'\\n'" : (c == 39 ? "'\\''" : (Character.isISOControl(c) ? Integer.toString(c) : (c < 65535 ? String.format("'%c'", Character.valueOf((char)c)) : Integer.toString(c)))));
        return x;
    }

    private boolean isLookahead(Object o) {
        return o != null && o.toString().startsWith(LOK);
    }

    private void printintv(PrintStream out, Interval v, boolean els, Object o) {
        String z;
        String s = v.isInfimumClosed() ? ">=" : ">";
        String t = v.isSupremumClosed() ? "<=" : "<";
        String a = els ? "\t\t\t} else if" : "\t\t\tif";
        int c = (Integer)v.getInfimumBound();
        int d = (Integer)v.getSupremumBound();
        String x = this.tostr(c);
        String y = this.tostr(d);
        String string = z = o != null && o.toString().startsWith(LOK) ? "__l__ && " : "";
        if (v.isClosed() && c == d) {
            out.format("%s(%s__c__ == %s) {\n", a, z, x);
        } else {
            out.format("%s(%s__c__ %s %s && __c__ %s %s) {\n", a, z, s, x, t, y);
        }
    }

    private void printobj(PrintStream out, Object o, boolean els, Object m) {
        String a = els ? "\t\t\t} else if" : "\t\t\tif";
        String z = m != null && m.toString().startsWith(LOK) ? "__l__ && " : "";
        out.format("%s(%s__c__.Equals(\"%s\")) {\n", a, z, o.toString());
    }

    private void printclchar(PrintStream out, char c, String a, String z) {
        String s = c == '\\' || c == '\'' ? String.format("'\\%c'", Character.valueOf(c)) : (c < ' ' ? String.format("((char)%d)", c) : String.format("'%c'", Character.valueOf(c)));
        out.format("%s(%s%s.Equals(__c__)) {\n", a, z, s);
    }

    private boolean printclass1(PrintStream out, Object o, boolean els, Object m) {
        String z;
        String a = els ? "\t\t\t} else if" : "\t\t\tif";
        String string = z = this.isLookahead(m) ? "__l__ && " : "";
        if (o instanceof Character) {
            this.printclchar(out, ((Character)o).charValue(), a, z);
        } else if (o instanceof Integer) {
            this.printclchar(out, (char)((Integer)o).intValue(), a, z);
        } else {
            String s = o.toString();
            if (E_CONST.matcher(s).matches()) {
                out.format("%s(%s__c__.Equals(%s)) {\n", a, z, s);
            } else {
                Matcher t = _STR.matcher(s);
                if (t.matches()) {
                    out.format("%s(%s\"%s\".Equals(__c__)) {\n", a, z, this.escapeprint(t.group(1)));
                } else {
                    t = _CLS.matcher(s);
                    if (t.matches()) {
                        return false;
                    }
                    if (s.length() == 1) {
                        this.printclchar(out, s.charAt(0), a, z);
                        out.format("\t\t\t} else if(%s\"%s\".Equals(__c__)) {\n", z, this.escapeprint(s));
                    } else {
                        out.format("%s(%s\"%s\".Equals(__c__)) {\n", a, z, this.escapeprint(s));
                    }
                }
            }
        }
        return true;
    }

    private boolean printclass2(PrintStream out, Object o, boolean els, Object m) {
        Matcher t;
        String s;
        String z;
        String a = els ? "\t\t\t} else if" : "\t\t\tif";
        String string = z = this.isLookahead(m) ? "__l__ && " : "";
        if (!(o instanceof Character || o instanceof Integer || E_CONST.matcher(s = o.toString()).matches() || (t = _STR.matcher(s)).matches())) {
            t = _CLS.matcher(s);
            if (t.matches()) {
                out.format("%s(%s__c__ is %s) {\n", a, z, t.group(1));
                return true;
            }
            s.length();
        }
        return false;
    }

    private String outln(boolean els, PrintStream out, String s) {
        if (els) {
            out.printf("\t\t\t}\n\t\t\telse if(%s)\n\t\t\t{\n", s);
        } else {
            out.printf("\t\t\tif(%s)\n\t\t\t{\n", s);
        }
        return "\t";
    }

    private boolean putend(String s, PrintStream out, DFAState<Object, ?, Void> dfa, boolean els) {
        TMBuilder.DBS x;
        DFABuilder.DBS b;
        if (dfa instanceof DFABuilder.DBS && (b = ((DFABuilder.DBS)dfa).getEnd()) != null) {
            this.outln(els, out, s);
            Object o = ((DFABuilder.DBS)dfa).getMealyEnd();
            if (o != null) {
                out.format("\t\t\t\t%s\n", ReplaceActionCSharp.replace(o.toString()));
            }
            out.format("\t\t\t\t__this__.STATE = %d;\n", this.getStateNo(b));
            out.format("\t\t\t\treturn 1;\n", new Object[0]);
            els = true;
        } else if (dfa instanceof TMBuilder.DBS && (x = ((TMBuilder.DBS)dfa).getEnd()) != null) {
            this.outln(els, out, s);
            this.printIntervalAction(out, dfa, ((TMBuilder.DBS)dfa).getMealyEnd());
            out.format("\t\t\t\t__this__.STATE = %d;\n", this.getStateNo(x));
            out.format("\t\t\t\treturn 1;\n", new Object[0]);
            els = true;
        }
        return els;
    }

    private boolean putuseredges(PrintStream out, DFAState<Object, ?, Void> dfa, boolean els) {
        Set<String> k;
        if (dfa instanceof DFABuilder.DBS && (k = ((DFABuilder.DBS)dfa).getUserEdges()) != null) {
            for (String x : k) {
                DFABuilder.DBS b = ((DFABuilder.DBS)dfa).getUserEdge(x);
                Object o = ((DFABuilder.DBS)dfa).getUserMealyEdge(x);
                if (els) {
                    out.printf("\t\t\t} else if(%s) {\n", x);
                } else {
                    out.printf("\t\t\tif(%s) {\n", x);
                }
                if (o != null) {
                    out.format("\t\t\t\t%s\n", ReplaceActionCSharp.replace(o.toString()));
                }
                out.format("\t\t\t\t__this__.STATE = %d;\n", this.getStateNo(b));
                out.format("\t\t\t\treturn 1;\n", new Object[0]);
                els = true;
            }
        }
        return els;
    }

    private boolean putothers(PrintStream out, DFAState<Object, ?, Void> dfa, boolean els, String so) {
        if (dfa instanceof TMBuilder.DBS) {
            TMBuilder.DBS x = ((TMBuilder.DBS)dfa).getOthers();
            if (x != null) {
                String s = this.outln(els, out, so);
                this.printIntervalAction(out, dfa, ((TMBuilder.DBS)dfa).getMealyOthers());
                out.format("%s\t\t\t__this__.STATE = %d;\n", s, this.getStateNo(x));
                out.format("%s\t\t\treturn 1;\n", s);
                return true;
            }
            return els;
        }
        if (!(dfa instanceof DFABuilder.DBS)) {
            return els;
        }
        DFABuilder.DBS a = (DFABuilder.DBS)dfa;
        DFABuilder.DBS b = a.getOthers();
        if (b != null) {
            String s = this.outln(els, out, so);
            Object o = a.getMealyOthers();
            if (o != null) {
                out.format("%s\t\t\t%s\n", s, ReplaceActionCSharp.replace(o.toString()));
            }
            out.format("%s\t\t\t__this__.STATE = %d;\n", s, this.getStateNo(b));
            out.format("%s\t\t\treturn 1;\n", s);
            return true;
        }
        b = a.getRecursive();
        if (b == null) {
            return els;
        }
        if (a.getRecursiveName().startsWith("g:")) {
            String s = this.outln(els, out, so);
            String t = a.getRecursiveName().substring(2);
            out.format("%s\t\t\t__this__.__Stkpush(%d, new LR%sEngine(__this__));\n", s, this.getStateNo(b), t);
            out.format("%s\t\t\t__this__.STATE = 0;\n", s);
            out.format("%s\t\t\treturn NinaAccept;\n", s);
            return true;
        }
        String s = this.outln(els, out, so);
        String t = ReplaceStrangeChar.replace(a.getRecursiveName());
        out.format("%s\t\t\t__this__.__Stkpush(%d, __this__.ENGINE_%s);\n", s, this.getStateNo(b), t);
        out.format("%s\t\t\t__this__.STATE = 0;\n", s);
        out.format("%s\t\t\treturn NinaAccept;\n", s);
        return true;
    }

    private void printNextStep(PrintStream out, DFAState<Object, ?, Void> d) {
        out.format("\t\t\t\t__this__.STATE = %d;\n", this.getStateNo(d));
        out.println("\t\t\t\treturn 1;");
    }

    private boolean printDynamicTransition(PrintStream out, DFAState<Object, ?, Void> dfa, boolean els) {
        DFABuilder.DBS d;
        if (dfa instanceof DFABuilder.DBS && (d = ((DFABuilder.DBS)dfa).getDynamic()) != null) {
            String s = ((DFABuilder.DBS)dfa).getDynamicVariable();
            out.print("\t\t\t");
            if (els) {
                out.print("}\n\t\t\telse ");
            }
            out.printf("if(__l__ && __this__.__startWith(__this__.%s, __c__))\n\t\t\t{\n", s);
            out.format("\t\t\t\t__this__.__Stkpush(%d,\n", this.getStateNo(d));
            out.format("\t\t\t\t\t\tnew DynamicEngine(__this__, __this__.%s, %d));\n", s, this.getStateNo(dfa));
            out.format("\t\t\t\t__this__.STATE = 0;\n", s);
            out.format("\t\t\t\treturn NinaAccept;\n", s);
            return true;
        }
        return els;
    }

    private void printWritetape(PrintStream out, String a) {
        if (a.length() != 0) {
            if (a.length() > 1) {
                out.printf("\t\t\t\t_writetape(\"%s\");\n", a);
            } else if (a.charAt(0) == '\\' || a.charAt(0) == '\'') {
                out.printf("\t\t\t\t_writetape('\\%c');\n", Character.valueOf(a.charAt(0)));
            } else {
                out.printf("\t\t\t\t_writetape('%c');\n", Character.valueOf(a.charAt(0)));
            }
        }
    }

    private void printIntervalAction(PrintStream out, DFAState<Object, ?, Void> d, Object o) {
        if (d instanceof TMBuilder.DBS) {
            if (o == null) {
                out.printf("\t\t\t\t_movetape(R);\n", new Object[0]);
            } else {
                String s = o.toString();
                if (!s.equals("__this__.UNGET($c);")) {
                    Matcher m = _IAT.matcher(s);
                    if (m.matches()) {
                        this.printWritetape(out, m.group(1));
                        if (!m.group(2).equals("*")) {
                            out.printf("\t\t\t\t_movetape(%s);\n", m.group(2));
                        }
                    } else {
                        this.printWritetape(out, s);
                    }
                }
            }
        } else if (o != null) {
            out.format("\t\t\t\t%s\n", ReplaceActionCSharp.replace(o.toString()));
        }
    }

    private void printState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        Object o;
        int c;
        boolean els = false;
        int sn = this.getStateNo(dfa);
        out.format("\t\tcase %d:\n", sn);
        if (dfa instanceof DFABuilder.DBS && ((DFABuilder.DBS)dfa).isOnlyEmptyTransition()) {
            out.format("\t\t\t__this__.STATE = %d;\n", this.getStateNo(((DFABuilder.DBS)dfa).getOthers()));
            out.println("\t\t\treturn 1;");
            return;
        }
        for (Interval v : dfa.getAlphabetRanges()) {
            if (v.isEmpty()) continue;
            c = this.infimumbound(v);
            if (v.isInfimumOpen()) {
                ++c;
            }
            if (!this.isLookahead(o = dfa.getLabelInt(c))) continue;
            o = dfa.getLabelInt(c);
            this.printintv(out, v, els, o);
            this.printIntervalAction(out, dfa, o);
            this.printNextStep(out, dfa.goInt(c));
            els = true;
        }
        for (Interval v : dfa.getAlphabetRanges()) {
            if (v.isEmpty()) continue;
            c = this.infimumbound(v);
            if (v.isInfimumOpen()) {
                ++c;
            }
            if (this.isLookahead(o = dfa.getLabelInt(c))) continue;
            o = dfa.getLabelInt(c);
            this.printintv(out, v, els, o);
            this.printIntervalAction(out, dfa, o);
            this.printNextStep(out, dfa.goInt(c));
            els = true;
        }
        els = this.printDynamicTransition(out, dfa, els);
        els = this.putend("__c__ < 0", out, dfa, els);
        els = this.putuseredges(out, dfa, els);
        if (els = this.putothers(out, dfa, els, "__c__ >= 0")) {
            out.println("\t\t\t}");
        }
        out.println("\t\t\treturn 0;");
    }

    private void printObjectState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        boolean els = false;
        int sn = this.getStateNo(dfa);
        out.format("\t\tcase %d:\n", sn);
        if (dfa instanceof DFABuilder.DBS && ((DFABuilder.DBS)dfa).isOnlyEmptyTransition()) {
            out.format("\t\t\t__this__.STATE = %d;\n", this.getStateNo(((DFABuilder.DBS)dfa).getOthers()));
            out.println("\t\t\treturn 1;");
            return;
        }
        for (Object p : dfa.getAlphabets()) {
            Object o = dfa.getLabel(p);
            this.printobj(out, p, els, o);
            this.printIntervalAction(out, dfa, o);
            DFAState<Object, ?, Void> d = dfa.go(p);
            out.format("\t\t\t\t__this__.STATE = %d;\n", this.getStateNo(d));
            out.println("\t\t\t\treturn 1;");
            els = true;
        }
        els = this.printDynamicTransition(out, dfa, els);
        els = this.putend("__c__ == null", out, dfa, els);
        els = this.putuseredges(out, dfa, els);
        if (els = this.putothers(out, dfa, els, "__c__ != null")) {
            out.println("\t\t\t}");
        }
        out.println("\t\t\treturn 0;");
    }

    private void printClassState(PrintStream out, DFAState<Object, ?, Void> dfa) {
        DFAState<Object, ?, Void> d;
        Object o;
        boolean els = false;
        int sn = this.getStateNo(dfa);
        out.format("\t\tcase %d:\n", sn);
        if (dfa instanceof DFABuilder.DBS && ((DFABuilder.DBS)dfa).isOnlyEmptyTransition()) {
            out.format("\t\t\t__this__.STATE = %d;\n", this.getStateNo(((DFABuilder.DBS)dfa).getOthers()));
            out.println("\t\t\treturn 1;");
            return;
        }
        for (Object p : dfa.getAlphabets()) {
            if (!this.printclass1(out, p, els, o = dfa.getLabel(p))) continue;
            this.printIntervalAction(out, dfa, o);
            d = dfa.go(p);
            out.format("\t\t\t\t__this__.STATE = %d;\n", this.getStateNo(d));
            out.println("\t\t\t\treturn 1;");
            els = true;
        }
        for (Object p : dfa.getAlphabets()) {
            if (!this.printclass2(out, p, els, o = dfa.getLabel(p))) continue;
            this.printIntervalAction(out, dfa, o);
            d = dfa.go(p);
            out.format("\t\t\t\t__this__.STATE = %d;\n", this.getStateNo(d));
            out.println("\t\t\t\treturn 1;");
            els = true;
        }
        els = this.printDynamicTransition(out, dfa, els);
        els = this.putend("__c__ == null", out, dfa, els);
        els = this.putuseredges(out, dfa, els);
        if (els = this.putothers(out, dfa, els, "__c__ != null")) {
            out.println("\t\t\t}");
        }
        out.println("\t\t\treturn 0;");
    }

    private boolean isProcessed(DFAState<Object, ?, Void> state) {
        return this.containsState(state);
    }

    private int getDeadStateNo() {
        Object s = this.builder.getDeadState();
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    private int getStateNoByLabel(String l) {
        Object s = this.builder.getStateByLabel(l);
        return this.containsState(s) ? this.stateNo(s) : -1;
    }

    @Override
    public void printStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printState(out, this.popStack());
            }
        }
    }

    @Override
    public void printObjectStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printObjectState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printObjectState(out, this.popStack());
            }
        }
    }

    @Override
    public void printClassStates(PrintStream out) {
        this.getStateNo(this.dfa.getInitialState());
        while (!this.isStackEmpty()) {
            this.printClassState(out, this.popStack());
        }
        for (String t : this.builder.getLabels()) {
            DFAState s = (DFAState)this.builder.getStateByLabel(t);
            if (s == null || this.isProcessed(s)) continue;
            this.getStateNo(s);
            while (!this.isStackEmpty()) {
                this.printClassState(out, this.popStack());
            }
        }
    }

    private void printPStates(PrintStream out, Set<Integer> a) {
        String d = "\t\treturn (";
        if (a.size() == 0) {
            out.println("\t\treturn false;");
        } else {
            for (Integer i : a) {
                out.print(d);
                out.format("__this__.STATE == %d", i);
                d = " ||\n\t\t\t\t";
            }
            out.println(");");
        }
    }

    @Override
    public void printAcceptStates(PrintStream out) {
        this.printPStates(out, this.acceptsIterable());
    }

    @Override
    public void printDeadStates(PrintStream out) {
        this.printPStates(out, this.deadsIterable());
    }

    @Override
    public void printEmptyTransitionStates(PrintStream out) {
        this.printPStates(out, this.emptyTransitionsIterable());
    }

    @Override
    public void printAcceptToken(PrintStream out) {
        boolean[] z = new boolean[1];
        int m = -1;
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!s.isAccepted()) continue;
            String p = null;
            m = -1;
            out.format("\t\tcase %d:\n", this.stateNo(s));
            for (Object a : s.getAccepted()) {
                int q;
                if (a == null || !(a instanceof NinaState) || (q = ((NinaState)a).getPriority()) < 0 || q <= m) continue;
                m = q;
            }
            for (Object a : s.getAccepted()) {
                NinaState n;
                String x;
                if (a == null || !(a instanceof NinaState) || (x = (n = (NinaState)a).getLabel()) == null || (x = x.trim()).equals("")) continue;
                if (m >= 0) {
                    if (n.getPriority() != m) continue;
                    p = x;
                    continue;
                }
                if (RET_CONST.matcher(x).matches()) {
                    p = x;
                    break;
                }
                if (p != null) {
                    this.getOptions().pwarn("ambiguousaccept", new Object[0]);
                }
                p = x;
            }
            p = p != null ? ReplaceAction.replace(p, z, this, this.getStateNo(s), this.builder.getLabelByState(s)) : "return __b__;";
            out.format("\t\t\t%s\n", p);
        }
    }

    @Override
    public void printActions(PrintStream out) {
        boolean[] a = new boolean[1];
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            String p = null;
            out.format("\t\tcase %d:\n", this.stateNo(s));
            String x = s.toString();
            if (x != null && !(x = x.trim()).equals("")) {
                p = x;
            }
            if (p == null) {
                out.println("\t\t\tbreak;");
                continue;
            }
            p = ReplaceAction.replace(p, a, this, this.stateNo(s), this.builder.getLabelByState(s));
            String[] stringArray = p.split("\n");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String v = stringArray[n2];
                out.format("\t\t\t%s\n", v);
                ++n2;
            }
            if (a[0]) continue;
            out.println("\t\t\tbreak;");
        }
    }

    @Override
    public void printImports(List<String> imp, PrintStream out) {
        for (String s : imp) {
            out.format("import %s;\n", s);
        }
    }

    @Override
    public void printIsEnd(PrintStream out) {
        HashSet<Integer> t = new HashSet<Integer>();
        String d = "\t\treturn (";
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!(s instanceof DFABuilder.DBS) || ((DFABuilder.DBS)s).getEnd() == null) continue;
            t.add(this.stateNo(s));
        }
        if (t.size() == 0) {
            out.println("\t\treturn false;");
        } else {
            for (Integer i : t) {
                out.print(d);
                out.format("__this__.STATE == %d", i);
                d = " ||\n\t\t\t\t";
            }
            out.println(");");
        }
    }

    @Override
    public void printDeadState(String n, PrintStream out) {
        out.printf("\t\t\treturn %d;\n", this.getDeadStateNo());
    }

    @Override
    protected void printRecover(PrintStream out) {
        String d = "";
        for (String x : this.builder.getLabels()) {
            if (!x.endsWith("Exception")) continue;
            DFAState s = (DFAState)this.builder.getStateByLabel(x);
            out.printf("\t\t\t%sif(e is %s) {\n", d, x);
            out.printf("\t\t\t\treturn %d;\n", this.getStateNo(s));
            d = "} else ";
        }
        if (d.equals("")) {
            out.println("\t\t\treturn -1;");
        } else {
            out.println("\t\t\t} else {");
            out.println("\t\t\t\treturn -1;");
            out.println("\t\t\t}");
        }
    }

    @Override
    public void printFinallyState(PrintStream out) {
        out.printf("\t\t\treturn %d;\n", this.getStateNoByLabel("finally"));
    }

    @Override
    protected void printInitTrap(PrintStream out) {
    }

    @Override
    protected void printNFADeadState(PrintStream out) {
        out.print("return (false");
        for (DFAState<Object, ?, Void> s : this.stateKeys()) {
            if (!s.isDead()) continue;
            out.print(" || ");
            out.print("__this__.STATE == ");
            out.print(this.stateNo(s));
        }
        out.println(");");
    }

    @Override
    protected void printAttrs(PrintStream out) {
    }

    @Override
    protected void printConstants(PrintStream out) {
        for (Map.Entry<String, Integer> t : this.quadro.getConstantMap().entrySet()) {
            out.printf("\t\tpublic const int %s = %d;\n", t.getKey(), (int)t.getValue());
        }
    }

    @Override
    public void reportStatistics(PrintStream std) {
        this.getOptions().print("statheader", new Object[0]);
        this.getOptions().print("statstates", this.stateSize());
        this.getOptions().print("stataccept", this.acceptsSize());
    }

    @Override
    protected InputStream openScript(ShEnvironment env) {
        if (this.options.getInjectFile() == null) {
            return NinaTranslator.class.getResourceAsStream("/net/morilib/nina/translate/nina_template." + this.getMachine() + ".cs.sh");
        }
        env.bind("TRANS_COMMAND", "nina_template." + this.getMachine() + ".cs.sh");
        return NinaTranslator.class.getResourceAsStream("/net/morilib/nina/translate/nina_injector.sh");
    }

    @Override
    public String getExtension() {
        return ".cs";
    }

    @Override
    protected PrintStream openOutput() throws IOException {
        return new PrintStream(this.getOptions().getOutputStream(this.getOptions().getTitleFile(this.getExtension())), true);
    }

    @Override
    protected AbstractNinaTranslator newPrototype() {
        NinaTranslatorCSharp r = new NinaTranslatorCSharp();
        r.quadro = this.quadro;
        return r;
    }

    @Override
    protected void appendValue(StringBuffer ot, StringBuffer b1) {
        String l = b1.toString();
        Object o = this.builder.getStateByLabel(l);
        String t = this.builder.getTypeByLabel(l);
        if (o == null) {
            ot.append("__").append(b1).append("__");
        } else if (t == null) {
            ot.append("(__this__.__stv[__this__.__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])");
        } else {
            ot.append("((");
            ot.append(t);
            ot.append(")(__this__.__stv[__this__.__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("]))");
        }
    }

    @Override
    protected void appendLvalue(StringBuffer ot, StringBuffer b1) {
        Object o = this.builder.getStateByLabel(b1.toString());
        if (o == null) {
            ot.append('@');
            ot.append(b1);
        } else {
            ot.append("(__this__.__stv[__this__.__slen - 1][");
            ot.append(this.stateNo(o));
            ot.append("])");
        }
    }

    @Override
    protected void appendMyPosition(StringBuffer ot, String ln, int cn) {
        ot.append("(__this__.__stv[__this__.__slen - 1][");
        ot.append(cn);
        ot.append("])");
    }

    @Override
    protected void appendReturn(StringBuffer ot) {
        ot.append("__r__");
    }

    @Override
    protected String getConstName(String t) {
        if (t.equals("EXIT")) {
            return "NinaAccept";
        }
        if (t.equals("FAIL")) {
            return "NinaFail";
        }
        if (t.equals("ACCEPT")) {
            return "NinaHaltAccept";
        }
        if (t.equals("REJECT")) {
            return "NinaHaltReject";
        }
        return null;
    }

    @Override
    protected void appendYield(StringBuffer ot, String b) {
        ot.append("__this__.yieldObject = (");
        ot.append(ReplaceActionCSharp.replace(b)).append(");");
        ot.append("return NinaYield;");
    }

    @Override
    protected LRTranslator getLRTranslator(Quadro q) {
        return new LRTranslatorCSharp(q);
    }

    @Override
    protected void setLocalenv(Quadro q, ShEnvironment env) {
        env.bind("VALTYPE", q.getOptionNvl("valtype", "object"));
        String s = q.getType();
        if (s != null && s.equals("string")) {
            env.bind("TYPE", s);
            env.bind("CTYPE", "string");
        } else if (s != null && s.equals("class")) {
            env.bind("TYPE", s);
            env.bind("CTYPE", "object");
        }
        s = q.getLexerType();
        if (s != null) {
            if (s.equals("string")) {
                env.bind("LTYPE", s);
                env.bind("LCTYPE", "string");
            } else if (s != null && s.equals("class")) {
                env.bind("LTYPE", s);
                env.bind("LCTYPE", "object");
            }
        }
    }
}

