/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.morilib.sed.SedCommand;
import net.morilib.sed.SedCommandBundle;
import net.morilib.sed.SedCommandLine;
import net.morilib.sed.SedCommandParser;
import net.morilib.sed.SedLineMatcher;
import net.morilib.sed.SedLineOption;
import net.morilib.sed.SedSyntaxException;
import net.morilib.sed.line.SedLastLineMatcher;
import net.morilib.sed.line.SedNumberLineMatcher;
import net.morilib.sed.line.SedPatternLineMatcher;
import net.morilib.sed.line.SedRelativeLineMatcher;
import net.morilib.sed.line.SedStepLineMatcher;

public class SedParser {
    public static List<SedCommandLine> parse(SedCommandBundle b, Reader rd) throws IOException {
        int c;
        ArrayList<SedCommandLine> r = new ArrayList<SedCommandLine>();
        PushbackReader re = new PushbackReader(rd);
        while ((c = re.read()) >= 0) {
            re.unread(c);
            SedCommandLine l = SedParser.parseLine(b, re);
            if (l != null) {
                r.add(l);
            }
            if ((c = re.read()) < 0 || c == 10 || c == 59) continue;
            throw new SedSyntaxException(String.valueOf((char)c));
        }
        return r;
    }

    public static SedCommandLine parseLine(SedCommandBundle b, String rd) {
        PushbackReader re = new PushbackReader(new StringReader(rd));
        try {
            SedCommandLine l = SedParser.parseLine(b, re);
            if (re.read() >= 0) {
                throw new SedSyntaxException();
            }
            return l;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static SedCommandLine parseLine(SedCommandBundle b, PushbackReader rd) throws IOException {
        SedCommandLine r = new SedCommandLine();
        r.matcher = SedParser.parseLines(rd);
        r.command = SedParser.parsecmd(b, rd, r.matcher);
        return r.command == null ? null : r;
    }

    static SedCommand parsecmd(SedCommandBundle b, PushbackReader rd, SedLineOption l) throws IOException {
        SedCommandParser p;
        int c = rd.read();
        if (c < 0) {
            throw new SedSyntaxException();
        }
        if (c == 39) {
            StringBuffer bf = new StringBuffer();
            while ((c = rd.read()) != 39) {
                if (c < 0) {
                    throw new SedSyntaxException();
                }
                bf.appendCodePoint(c);
            }
            p = b.get(bf.toString());
        } else if (c == 10 || (p = b.get(c)) == null) {
            throw new SedSyntaxException();
        }
        return p.parse(b, rd, l);
    }

    private static void setneg(PushbackReader rd, SedLineOption r) throws IOException {
        int c = rd.read();
        if (c == 33) {
            r.negate = true;
        } else if (c >= 0) {
            rd.unread(c);
        }
    }

    public static SedLineOption parseLines(PushbackReader rd) throws IOException {
        SedLineOption r;
        boolean am = false;
        boolean ci = false;
        int c = rd.read();
        if (c == 103) {
            c = rd.read();
            if (c < 0 || c == 10) {
                throw new SedSyntaxException();
            }
            String s = SedParser.getstr(rd, c);
            while ((c = rd.read()) >= 0) {
                if (c == 73 || c == 105) {
                    ci = true;
                    continue;
                }
                if (c == 77 || c == 109) {
                    am = true;
                    continue;
                }
                if (c < 0) break;
                rd.unread(c);
                break;
            }
            r = new SedLineOption(s, ci, am);
            SedParser.setneg(rd, r);
        } else {
            SedLineMatcher m;
            if (c >= 0) {
                rd.unread(c);
            }
            if ((m = SedParser.line(rd)) != null) {
                if (m instanceof SedRelativeLineMatcher) {
                    throw new SedSyntaxException();
                }
                c = rd.read();
                if (c == 44) {
                    SedLineMatcher n = SedParser.line(rd);
                    if (m instanceof SedNumberLineMatcher && n instanceof SedNumberLineMatcher) {
                        long a = ((SedNumberLineMatcher)m).getLineno();
                        long b = ((SedNumberLineMatcher)n).getLineno();
                        if (b < a) {
                            throw new SedSyntaxException();
                        }
                    } else if (m instanceof SedLastLineMatcher && !(n instanceof SedLastLineMatcher)) {
                        throw new SedSyntaxException();
                    }
                    r = new SedLineOption(m, n);
                    SedParser.setneg(rd, r);
                } else if (c == 33) {
                    r = new SedLineOption(m);
                    r.negate = true;
                } else if (c == 126) {
                    if (!(m instanceof SedNumberLineMatcher)) {
                        throw new SedSyntaxException();
                    }
                    m = new SedStepLineMatcher(((SedNumberLineMatcher)m).getLineno(), SedParser.nums(rd));
                    r = new SedLineOption(m);
                    SedParser.setneg(rd, r);
                } else {
                    if (c >= 0) {
                        rd.unread(c);
                    }
                    r = new SedLineOption(m);
                }
            } else {
                r = new SedLineOption();
            }
        }
        return r;
    }

    private static SedLineMatcher getlinere(PushbackReader rd, int d) throws IOException {
        int c;
        boolean am = false;
        boolean ci = false;
        String s = SedParser.getstr(rd, d);
        while ((c = rd.read()) >= 0) {
            if (c == 73 || c == 105) {
                ci = true;
                continue;
            }
            if (c == 77 || c == 109) {
                am = true;
                continue;
            }
            if (c < 0) break;
            rd.unread(c);
            break;
        }
        return new SedPatternLineMatcher(s, ci, am);
    }

    static SedLineMatcher line(PushbackReader rd) throws IOException {
        SedLineMatcher r;
        int c = rd.read();
        if (c == 47) {
            return SedParser.getlinere(rd, 47);
        }
        if (c == 36) {
            r = SedLastLineMatcher.INSTANCE;
        } else if (c >= 48 && c <= 57) {
            rd.unread(c);
            r = new SedNumberLineMatcher(SedParser.nums(rd));
        } else if (c == 43) {
            r = new SedRelativeLineMatcher(SedParser.nums(rd));
        } else {
            if (c == 92) {
                int d = rd.read();
                if (d < 0) {
                    throw new SedSyntaxException();
                }
                return SedParser.getlinere(rd, d);
            }
            if (c >= 0) {
                rd.unread(c);
            }
            r = null;
        }
        return r;
    }

    static long nums(PushbackReader rd) throws IOException {
        int c;
        long r = 0L;
        while ((c = rd.read()) >= 48 && c <= 57) {
            if ((r = r * 10L + (long)(c - 48)) >= 0L) continue;
            throw new SedSyntaxException();
        }
        if (r <= 0L) {
            throw new SedSyntaxException();
        }
        if (c >= 0) {
            rd.unread(c);
        }
        return r;
    }

    static String getstr(PushbackReader rd, int dlm) throws IOException {
        int c;
        StringBuffer b = new StringBuffer();
        boolean esc = false;
        while ((c = rd.read()) != dlm || esc) {
            if (c < 0) {
                throw new SedSyntaxException();
            }
            if (esc) {
                esc = false;
                continue;
            }
            esc = c == 92;
            if (esc) continue;
            b.appendCodePoint(c);
        }
        return b.toString();
    }
}

