/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sed.cmd;

import java.io.IOException;
import net.morilib.sed.SedCommand;
import net.morilib.sed.SedLineBuffer;
import net.morilib.sed.SedSpace;
import net.morilib.sed.SedSubstituteFlags;

public class SedSCommand
implements SedCommand {
    private String pattern;
    private String replace;
    private SedSubstituteFlags flags;

    public SedSCommand(String pattern, String replace, SedSubstituteFlags flags) {
        this.pattern = pattern;
        this.replace = replace;
        this.flags = flags;
    }

    @Override
    public String getLongDescription() {
        return "Substitute";
    }

    @Override
    public char getName() {
        return 's';
    }

    @Override
    public void process(SedSpace s, SedLineBuffer rd) throws IOException {
        s.substitute(this.pattern, this.replace, this.flags);
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getReplace() {
        return this.replace;
    }

    public SedSubstituteFlags getFlags() {
        return this.flags;
    }

    public int hashCode() {
        return (this.pattern.hashCode() * 17 + this.replace.hashCode()) * 17 + this.flags.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof SedSCommand) {
            return this.pattern.equals(((SedSCommand)o).pattern) && this.replace.equals(((SedSCommand)o).replace) && this.flags.equals(((SedSCommand)o).flags);
        }
        return false;
    }

    public String toString() {
        return "s/" + this.pattern + "/" + this.replace + "/" + this.flags;
    }
}

