/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.List;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShString;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.misc.XtraceStream;

public class ShKeyword
extends ShToken {
    private String value;

    public ShKeyword(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public boolean isString() {
        return true;
    }

    @Override
    public boolean equalsKeyword(String keyword) {
        return this.value.equals(keyword);
    }

    @Override
    public List<ShToken> replaceBracket() {
        return Collections.singletonList(this);
    }

    @Override
    public ShToken replaceTilde(ShEnvironment env) {
        return new ShString(ShToken.replaceTilde(env, this.value));
    }

    @Override
    public List<ShToken> replaceParameter(ShEnvironment env, PrintStream err) {
        return Collections.singletonList(this);
    }

    @Override
    public ShToken replaceCommand(ShEnvironment env, ShFileSystem fs, ShRuntime run, XtraceStream p) {
        return this;
    }

    @Override
    public ShToken replaceArithmetic(ShEnvironment env) {
        return this;
    }

    @Override
    public List<String> splitWord(String ifs) {
        return Collections.singletonList(this.value);
    }

    @Override
    public boolean isWildcard() {
        return ShToken.isWildcard(this.value);
    }

    @Override
    public boolean isBind() {
        return ShToken.isBind(this.value);
    }

    @Override
    public void bindVariable(ShEnvironment env, ShFileSystem fs, ShRuntime run, PrintStream err, XtraceStream p) throws IOException, ShSyntaxException {
        ShToken.bindVariable(env, fs, run, err, p, this.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof ShKeyword && this.value.equals(((ShKeyword)o).value);
    }

    public String toString() {
        return this.value;
    }
}

