/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShFiles;
import net.morilib.sh.ShRedirector;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.ShTrees;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeRedirect
implements ShTree {
    private List<ShRedirector> types;
    private List<ShToken> files;
    private ShTree line;
    private transient ShTree comp = null;

    public ShTreeRedirect(ShTree line, List<ShRedirector> types, List<ShToken> files) {
        this.types = new ArrayList<ShRedirector>(types);
        this.files = new ArrayList<ShToken>(files);
        this.line = line;
    }

    @Override
    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmds, ShRuntime run, InputStream stdin, PrintStream stdout, PrintStream stderr, XtraceStream p) throws IOException, ShSyntaxException {
        InputStream in = stdin;
        PrintStream[] printStreamArray = new PrintStream[3];
        printStreamArray[1] = stdout;
        printStreamArray[2] = stderr;
        PrintStream[] a = printStreamArray;
        int i = 0;
        while (i < this.types.size()) {
            in = ShFiles.redirect(env, fs, run, this.types.get(i), this.files.get(i), stdin, a, p);
            ++i;
        }
        if (this.comp == null) {
            this.comp = ShTrees.compile(this.line);
        }
        return this.comp.eval(env, fs, cmds, run, in, a[1], a[2], p);
    }

    @Override
    public void compileInternally(ShTreeExpressionMachine.Builder b, Object brk, Object cnt) {
        b.add(this);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.line);
        int i = 0;
        while (i < this.types.size()) {
            b.append(' ').append(this.types.get(i));
            if (this.files.get(i) != null) {
                b.append(' ').append(this.files.get(i));
            }
            ++i;
        }
        return b.toString();
    }
}

