/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.sh;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.morilib.sh.ShBuiltInCommands;
import net.morilib.sh.ShCommandNotFoundException;
import net.morilib.sh.ShEnvironment;
import net.morilib.sh.ShFileSystem;
import net.morilib.sh.ShFiles;
import net.morilib.sh.ShFunctionEnvironment;
import net.morilib.sh.ShParser;
import net.morilib.sh.ShProcess;
import net.morilib.sh.ShRedirector;
import net.morilib.sh.ShRootShellEnvironment;
import net.morilib.sh.ShRuntime;
import net.morilib.sh.ShString;
import net.morilib.sh.ShSubEnvironment;
import net.morilib.sh.ShSyntaxException;
import net.morilib.sh.ShToken;
import net.morilib.sh.ShTree;
import net.morilib.sh.ShTreeExpressionMachine;
import net.morilib.sh.ShTrees;
import net.morilib.sh.misc.FileTypeUtils;
import net.morilib.sh.misc.XtraceStream;

public class ShTreeSimpleCommand
implements ShTree {
    public static final int ALL = 65535;
    public static final int FUNCTION = 1;
    public static final int BUILTIN = 2;
    public static final int EXTERNAL = 4;
    public static final int COMMAND = 6;
    private List<ShRedirector> types;
    private List<ShToken> files;
    private List<ShToken> line;
    private List<ShToken> binds;
    private int flags;

    public ShTreeSimpleCommand(List<ShToken> line, List<ShRedirector> types, List<ShToken> files, List<ShToken> binds, int flags) {
        this.types = new ArrayList<ShRedirector>(types);
        this.files = new ArrayList<ShToken>(files);
        this.line = new ArrayList<ShToken>(line);
        this.binds = new ArrayList<ShToken>(binds);
        this.flags = flags;
    }

    public ShTreeSimpleCommand(List<ShToken> line, List<ShRedirector> types, List<ShToken> files, int flags) {
        this.types = new ArrayList<ShRedirector>(types);
        this.files = new ArrayList<ShToken>(files);
        this.line = new ArrayList<ShToken>(line);
        this.binds = Collections.emptyList();
        this.flags = flags;
    }

    public List<String> substitute(ShEnvironment env, ShBuiltInCommands cmd, ShRuntime run, ShFileSystem fs, PrintStream err, XtraceStream p) throws IOException, ShSyntaxException {
        return ShTrees.substituteCommand(env, cmd, run, fs, err, p, this.line);
    }

    @Override
    public int eval(ShEnvironment env, ShFileSystem fs, ShBuiltInCommands cmd, ShRuntime run, InputStream stdin, PrintStream out, PrintStream err, XtraceStream pr) throws IOException, ShSyntaxException {
        ShProcess p;
        int z;
        InputStream in = stdin;
        ShEnvironment e2 = new ShFunctionEnvironment(env);
        for (ShToken t : this.binds) {
            t.bindVariable(e2, fs, run, err, pr);
        }
        if (env.isSet("noexec")) {
            return 0;
        }
        PrintStream[] printStreamArray = new PrintStream[3];
        printStreamArray[1] = out;
        printStreamArray[2] = err;
        PrintStream[] a = printStreamArray;
        int i = 0;
        while (i < this.types.size()) {
            in = ShFiles.redirect(env, fs, run, this.types.get(i), this.files.get(i), in, a, pr);
            ++i;
        }
        List<String> l = ShTrees.substituteCommand(env, cmd, run, fs, err, pr, this.line);
        if (env.isSet("xtrace") && pr != null) {
            String v = ShTrees.substituteCase(env, run, fs, err, pr, new ShString(env.find("PS4")));
            pr.printPrompt(v);
            for (String s : l) {
                pr.print(s);
                pr.print(' ');
            }
            pr.println();
        }
        if (l.size() == 0) {
            return 0;
        }
        String n = l.get(0);
        ShTree f = env.findFunction(n);
        if (f != null && (this.flags & 1) != 0) {
            e2.put("#", String.valueOf(l.size()));
            i = 0;
            while (i < l.size()) {
                e2.put(String.valueOf(i), l.get(i));
                ++i;
            }
            z = f.eval(e2, fs, cmd, run, in, a[1], a[2], pr);
        } else if ((this.flags & 2) != 0 && (p = cmd.find(n)) != null) {
            l.set(0, e2.find("0"));
            z = p.main(e2, fs, in, a[1], a[2], l.toArray(new String[0]));
        } else if ((this.flags & 4) != 0 && (p = ShFiles.findCommand(env, fs, cmd, n)) != null) {
            z = p.main(e2, fs, in, a[1], a[2], l.toArray(new String[0]));
        } else {
            String[] y = FileTypeUtils.parseShebang(fs.getFile(n));
            if (y != null && y[1] != null && y[1].equals("jsh")) {
                e2 = new ShSubEnvironment(env.getEnvironment());
                for (ShToken t : this.binds) {
                    t.bindVariable(e2, fs, run, err, pr);
                }
                e2 = new ShRootShellEnvironment(e2);
                e2.put("#", String.valueOf(l.size()));
                i = 1;
                while (i < l.size()) {
                    e2.put(String.valueOf(i), l.get(i));
                    ++i;
                }
                InputStream sin = fs.getFile(n).getInputStream();
                f = ShParser.parse(sin, env.getCharset());
                z = f.eval(e2, fs, cmd, run, in, a[1], a[2], pr);
            } else {
                throw new ShCommandNotFoundException(n);
            }
        }
        if (a[1] != out && a[1] != err) {
            a[1].close();
        }
        if (a[2] != out && a[2] != err) {
            a[2].close();
        }
        env.put("?", String.valueOf(z));
        return z;
    }

    @Override
    public void compileInternally(ShTreeExpressionMachine.Builder b, Object brk, Object cnt) {
        b.add(this);
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        String d = "";
        for (ShToken l : this.line) {
            b.append(d).append(l);
            d = " ";
        }
        int i = 0;
        while (i < this.types.size()) {
            b.append(' ').append(this.types.get(i));
            if (this.files.get(i) != null) {
                b.append(' ').append(this.files.get(i));
            }
            ++i;
        }
        return b.toString();
    }
}

