/*
 * Copyright 2013 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.awk.nano.expr;

import net.morilib.awk.nano.io.AwkFiles;
import net.morilib.awk.nano.namespace.AwkNamespace;
import net.morilib.awk.nano.value.AwkValue;

/**
 * べき乗を表す中間表現です。
 * 
 * @author MORIGUCHI, Yuichiro 2013/03
 */
public class AwkPowerOp extends AwkExpression {

	private AwkExpression e1, e2;

	/**
	 * 中間表現を生成します。
	 * 
	 * @param e1 底
	 * @param e2 指数
	 */
	public AwkPowerOp(AwkExpression e1, AwkExpression e2) {
		this.e1 = e1;
		this.e2 = e2;
	}

	/* (non-Javadoc)
	 * @see net.morilib.awk.expr.AwkExpression#eval(net.morilib.awk.namespace.AwkNamespace, net.morilib.awk.io.AwkFiles)
	 */
	public AwkValue eval(AwkNamespace ns, AwkFiles o) {
		AwkValue r1 = e1.eval(ns, o), r2 = e2.eval(ns, o);

		return AwkValue.pow(r1, r2);
	}

}
