/*
 * Copyright 2009 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.lisp.nano.subr;

import java.math.BigInteger;

import net.morilib.lisp.nano.Datum;
import net.morilib.lisp.nano.Environment;
import net.morilib.lisp.nano.LispDouble;
import net.morilib.lisp.nano.LispInteger;
import net.morilib.lisp.nano.LispMessage;
import net.morilib.lisp.nano.LispReal;

/**
 * 
 *
 *
 * @author MORIGUCHI, Yuichiro 2011/07/02
 */
public class Modulo extends BinaryArgs {

	@Override
	protected Datum execute(
			Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
		if((c1a instanceof LispReal) && (c2a instanceof LispReal)) {
			LispReal r1 = (LispReal)c1a;
			LispReal r2 = (LispReal)c2a;

			if(r2.signum() == 0) {
				throw mesg.getError("err.divbyzero");
			} else if(r1.isInteger() && r2.isInteger()) {
				BigInteger a = r1.getBigInteger();
				BigInteger b = r2.getBigInteger();
				BigInteger r;

				if(b.compareTo(BigInteger.ZERO) > 0) {
					r = a.mod(b);
				} else {
					r = b.add(a.mod(b.abs()));
				}

				if(r1.isExact() && r2.isExact()) {
					return LispInteger.valueOf(r);
				} else {
					return new LispDouble(r.doubleValue());
				}
			} else if(!r1.isInteger()) {
				throw mesg.getError("err.require.int", r1);
			} else {
				throw mesg.getError("err.require.int", r2);
			}
		} else if(!(c1a instanceof LispReal)) {
			throw mesg.getError("err.require.int", c1a);
		} else {
			throw mesg.getError("err.require.int", c2a);
		}
	}

}
