/*
 * Copyright 2009-2010 Yuichiro Moriguchi
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package net.morilib.nina.lint;

/**
 *
 *
 * @author MORIGUCHI, Yuichiro 2014/01/11
 */
public abstract class LintCell {

	//
	private int character, x, y;
	private LintCells cells;
	boolean error = false;

	/**
	 * 
	 * @param ch
	 */
	public LintCell(LintCells cells, int ch, int x, int y) {
		this.cells = cells;
		character  = ch;
		this.x = x;
		this.y = y;
	}

	/**
	 * 
	 * @param msg
	 * @param args
	 */
	protected void addWarning(String msg, Object... args) {
		cells.addWarning(msg, args);
	}

	/**
	 * 
	 * @return
	 */
	public abstract boolean isPath();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isFrame();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isAlphabet();

	/**
	 * 
	 * @return
	 */
	public abstract boolean isBlank();

	/**
	 */
	public abstract void validate();

	/**
	 * 
	 * @return
	 */
	public int getCharacter() {
		return character;
	}

	/**
	 * 
	 * @return
	 */
	public int getX() {
		return x + 1;
	}

	/**
	 * 
	 * @return
	 */
	public int getY() {
		return y + 1 + cells.getYOffset();
	}

	/**
	 * 
	 * @return
	 */
	public LintCell north() {
		return cells.get(x, y - 1);
	}

	/**
	 * 
	 * @return
	 */
	public LintCell south() {
		return cells.get(x, y + 1);
	}

	/**
	 * 
	 * @return
	 */
	public LintCell west() {
		return cells.get(x - 1, y);
	}

	/**
	 * 
	 * @return
	 */
	public LintCell east() {
		return cells.get(x + 1, y);
	}

	/**
	 * 
	 */
	public boolean isError() {
		return error;
	}

	/* (non-Javadoc)
	 * @see java.lang.Object#toString()
	 */
	public String toString() {
		char[] a = new char[1];

		a[0] = (char)character;
		return new String(a);
	}

}
