#ifndef DESCTABLE_H_
#define DESCTABLE_H_

namespace system
{

	struct SegmentDescriptor
	{
		short limitLow, baseLow;
		char baseMid, accessRight, limitHigh, baseHigh;
	};
	struct GateDescriptor
	{
		short offsetLow, selector;
		char dwCount, accessRight;
		short offsetHigh;
	};
	class GDT
	{
	public:
		static SegmentDescriptor *gdt;
		static void SetSegmDesc(SegmentDescriptor *sd, unsigned int limit, unsigned int base, unsigned int ar);
		static void init();
	};
	class IDT
	{
	public:
		static GateDescriptor *idt;
		static void SetGateDesc(GateDescriptor *gd, unsigned int offset, unsigned int selector, unsigned int ar);
		static void init();
	};
}

#endif /*DESCTABLE_H_*/
