#ifndef DEQUE_H_
#define DEQUE_H_

namespace std {
	template <class T>
	class deque {
		// Rs[RXgN^p@֎~
		deque(deque& org) {}
		// Rs[Zqp@֎~
		void operator =(deque& org) {}
		
	protected:
		T* pt_; // IɊ蓖Ăzւ̃|C^
		size_t capacity_; // 蓖čς݂̔zTCY
		size_t elements_; // i[vf
		int increase_; // z񑝉
		int findex_; // 擪vfp
		int bindex_; // vfp
		
		/*
		 * LpVeBL
		 */
		void expand();
		
	public:
		/*
		 * tftHgRXgN^
		 */
		explicit
		deque(int capacity = 5, int increase = 5);
		
		/*
		 * ftHgfXgN^
		 */
		virtual ~deque();
		
		/*
		 * vfԂ
		 */
		inline size_t size() const;
		
		/*
		 * ővfԂ
		 */
		inline size_t max_size() const;
		
		/*
		 * z񂪋󂩂ǂ
		 */
		bool empty() const;
		
		/*
		 * 擪ɗvfǉ
		 */
		void push_front(const T& x);
		
		/*
		 * ɗvfǉ
		 */
		void push_back(const T& x);
		
		/*
		 * 擪vf폜
		 */
		void pop_front();
		
		/*
		 * vf폜
		 */
		void pop_back();
		
		/*
		 * 擪vfQ
		 */
		T& front();
		
		/*
		 * vfQ
		 */
		T& back();
	};

	template <class T>
	void deque<T>::expand() {
		// increase_LpVeBL
		capacity_ += increase_;
		
		// Vz𓮓IɊm
		T* newpt_ = new T[capacity_];
		
		int newfindex_ = (capacity_ - elements_) / 2;
		
		// f[^VzɃRs[
		int i;
		for(i = 0; i < elements_; i++) {
			newpt_[newfindex_ + i] = pt_[findex_ + i];
		}
		findex_ = newfindex_;
		bindex_ = newfindex_ + elements_;
		
		delete[] pt_;
		pt_ = newpt_;
	}
	
	template <class T>
	deque<T>::deque(int capacity, int increase) {
		// LpVeBݒ Œl5
		capacity_ = capacity > 5 ? capacity : 5;
		// ݒ
		increase_ = increase > 0 ? increase : 5;
		
		capacity_ = capacity;
		increase_ = increase;
		
		// z𓮓IɊm
		pt_ = new T[capacity_];
		
		// ̒lT()ŏ
		for(int i = 0; i < capacity_; i++) {
			pt_[i] = T();
		}
		
		// findex_bindex_𒆉ʒuɐݒ
		findex_ = bindex_ = capacity_ / 2;
	}
	
	template <class T>
	deque<T>::~deque() {
		delete[] pt_;
	}
		
	template <class T>
	size_t deque<T>::size() const {
		return elements_;
	}
	
	template <class T>
	size_t deque<T>::max_size() const {
		return capacity_;
	}
	
	template <class T>
	bool deque<T>::empty() const {
		return elements_ == 0 ? true : false;
	}
	
	template <class T>
	void deque<T>::push_front(const T& x) {
		if(--findex_ >= 0) {
			pt_[findex_] = x;
			elements_++;
		} else {
			// findex_ɖ߂
			findex_++;
			
			// LpVeBL
			expand();
			pt_[findex_] = x;
			elements_++;
		}
	}

	template <class T>
	void deque<T>::push_back(const T& x) {
		if(bindex_ <= capacity_ - 1) {
			pt_[bindex_++] = x;
			elements_++;
		} else {
			// LpVeBL
			expand();
			pt_[bindex_++] = x;
			elements_++;
		}
	}
	
	template <class T>
	void deque<T>::pop_front() {
		if(findex_ != bindex_) {
			pt_[findex_] = T();
			findex_++;
			elements_--;
		} else {
			pt_[findex_] = T();
		}
	}
	
	template <class T>
	void deque<T>::pop_back() {
		if(bindex_ != findex_) {
			pt_[--bindex_] = T();
			elements_--;
		} else {
			pt_[findex_] = T();
		}
	}
	
	template <class T>
	T& deque<T>::front() {
		return pt_[findex_];
	}
	
	template <class T>
	T& deque<T>::back() {
		return pt_[bindex_];
	}
}

#endif /*QUEUE_H_*/
