#include "../../bootpack.h"
using namespace systemtask;

void system::task_b_main() {
	Task* current_task = g_taskctl->get_current_task();
	Sheet* sht = g_shtctl->alloc(g_taskctl->get_taskid(current_task));
	sht->init(300, 200);
	sht->set_invisible_color(0x0001);
	Window::make(sht, false);
	Picture* buf = sht->get_buffer();
	buf->box(3,  29, 300 - 4, 200 - 4, Screen::TASKBAR_COLOR);
	buf->putstr(10, 8, "load", 0xffff);
	buf->putstr(11, 8, "load", 0xffff);
	g_shtctl->updown(sht, 4);
	g_shtctl->slide(sht, 200, 20);
	
	queue<Message>* fifo = current_task->fifo();
	Message msg;
	char s[256], tmp[256];
	Timer* tim = g_timerctl->alloc();
	tim->set_task(g_taskctl->get_current_task(), 1);
	timer_settime(tim, 50);
	int count = 0, count_10sec = 0, count_loop = 19;
	int percent = 0;
	for (;;) {
		io_cli();
		if (fifo->size() == 0) {
			g_taskctl->sleep(current_task);
			io_sti();
			continue;
		}
		msg = fifo->back();
		fifo->pop();
		io_sti();
		if (msg.type == MSG::TYPE::TIMER) {
			if (msg.arg1 == 1) {
				timer_settime(tim, 50);
//				buf->box(20, 50 + 16 * 1, 20 + 8 * 18 - 1, 50 + 16 * 4 - 1, Screen::TASKBAR_COLOR);
//				buf->putstr(20, 50 + 12 * 1, "ѱ ޶", 0x0000, font_mini);
				count = load_count;
				putstr_sht(sht, 20, 50 + 13 * 1, "ѱ ޶", 0x0000, Screen::TASKBAR_COLOR, font_mini);
				if (count >= 50) { count = 50; }
				if (count < 0) { count = 0; }
				percent = (50 - count) * 2;
				sprintf(s, "%3u0 msec/sec", count * 2);
				putstr_sht(sht, 20, 50 + 13 * 2, s, 0x0000, Screen::TASKBAR_COLOR, font_mini);
//				buf->putstr(20, 50 + 16 * 2, s, 0x0000);
				sprintf(s, "0.5sec CPU̶ %2u %%", percent);
				putstr_sht(sht, 20, 50 + 13 * 3, s, 0x0000, Screen::TASKBAR_COLOR, font_mini);
//				buf->putstr(20, 50 + 16 * 3, s, 0x0000);
//				g_shtctl->refresh(sht, 20, 50 + 16 * 1, 20 + 8 * 18, 50 + 16 * 4);
				load_count = 0;
				count_10sec += count;
				count_loop++;
				if (count_loop >= 20) {
					count_loop = 0;
					percent = (1000 - count_10sec) / 10;
					sprintf(s, "10 sec CPU̶ %2u %%", percent);
					putstr_sht(sht, 20, 50 + 13 * 4, s, 0x0000, Screen::TASKBAR_COLOR, font_mini);
					count_10sec = 0;
				}
				sprintf(s, "Power On %5d sec", g_timerctl->get_count() / 100);
				putstr_sht(sht, 20, 50 + 13 * 5, s, 0x0000, Screen::TASKBAR_COLOR, font_mini);
			}
		}
	}
}
