/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: worker.h,v 1.1.1.1 2003/05/10 16:34:28 fuyu Exp $
 */

#ifndef _WORKER_H_
#define _WORKER_H_

#include <glib.h>
#include <pthread.h>

typedef struct _WorkerThread WorkerThread;
typedef void JobFunc(WorkerThread *employee, gpointer args);

typedef enum
{
  GO_AHEAD,
  DIE_NOW
} ThreadControl;


struct _WorkerThread
{
  pthread_t id;
  volatile ThreadControl command;
};


typedef struct _WorkerJob
{
  volatile gboolean canceled;
  JobFunc *job;
  gpointer args;
} WorkerJob;


void initialize_worker(int initial_num_threads, int maximum_num_threads);
void commit_job(WorkerJob *job);
void terminate_workers(void);

#endif	/* _WORKER_H_ */
