/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: icon_label.c,v 1.4 2003/12/30 21:53:28 fuyu Exp $
 */

#include "icon_label.h"

#include "ochusha_private.h"

#include <gtk/gtk.h>

#if 0
#include <stdio.h>
#include <stdlib.h>
#endif


static void icon_label_class_init(IconLabelClass *klass);
static void icon_label_init(IconLabel *icon_label);
static void icon_label_finalize(GObject *object);
static void icon_label_destroy(GtkObject *object);


static void icon_label_size_request(GtkWidget *widget,
				    GtkRequisition *requisition);
static void icon_label_size_allocate(GtkWidget *widget,
				     GtkAllocation *allocation);
static int icon_label_expose(GtkWidget *widget, GdkEventExpose *event);


GType
icon_label_get_type(void)
{
  static GType tl_type = 0;

  if (tl_type == 0)
    {
      static const GTypeInfo tl_info =
	{
	  sizeof(IconLabelClass),
	  NULL,	/* base_init */
	  NULL,	/* base_finalize */
	  (GClassInitFunc)icon_label_class_init,
	  NULL,	/* class_finalize */
	  NULL,	/* class_data */
	  sizeof(IconLabel),
	  0,	/* n_preallocs */
	  (GInstanceInitFunc)icon_label_init,
	};

      tl_type = g_type_register_static(GTK_TYPE_LABEL,
				       "IconLabel", &tl_info, 0);
    }

  return tl_type;
}


static GtkLabelClass *parent_class = NULL;
static GtkMiscClass *parent_parent_class = NULL;


static void
icon_label_class_init(IconLabelClass *klass)
{
  GObjectClass *o_class = (GObjectClass *)klass;
  GtkObjectClass *object_class = (GtkObjectClass *)klass;
  GtkWidgetClass *widget_class = (GtkWidgetClass *)klass;

  parent_class = g_type_class_peek_parent(klass);
  parent_parent_class = g_type_class_peek_parent(parent_class);

  /* GObject signals */
  o_class->finalize = icon_label_finalize;

  /* GtkObject signals */
  object_class->destroy = icon_label_destroy;

  /* GtkLabel signals */
  widget_class->size_request = icon_label_size_request;
  widget_class->size_allocate = icon_label_size_allocate;

  widget_class->expose_event = icon_label_expose;
}


static void
icon_label_init(IconLabel *icon_label)
{
  icon_label->icon = NULL;
  icon_label->icon_y_adjustment = 0;
}


static void
icon_label_finalize(GObject *object)
{
#if 0
  IconLabel *icon_label = ICON_LABEL(object);
#endif
#if DEBUG_WIDGET_MOST
  fprintf(stderr, "icon_label_finalize\n");
#endif

  if (G_OBJECT_CLASS(parent_class)->finalize)
    (*G_OBJECT_CLASS(parent_class)->finalize)(object);
}


static void
icon_label_destroy(GtkObject *object)
{
  IconLabel *icon_label = ICON_LABEL(object);

#if DEBUG_WIDGET_MOST
  fprintf(stderr, "icon_label_destroy\n");
#endif

  if (icon_label->icon != NULL)
    {
      OCHU_OBJECT_UNREF(G_OBJECT(icon_label->icon));
      icon_label->icon = NULL;
    }

  if (GTK_OBJECT_CLASS(parent_class)->destroy)
    (*GTK_OBJECT_CLASS(parent_class)->destroy)(object);
}


static void
icon_label_size_request(GtkWidget *widget, GtkRequisition *requisition)
{
  IconLabel *icon_label = ICON_LABEL(widget);
  (*GTK_WIDGET_CLASS(parent_class)->size_request)(widget, requisition);
  if (icon_label->icon != NULL)
    {
      /* iconʬä롣*/
      requisition->width += gdk_pixbuf_get_width(icon_label->icon);
      requisition->height = MAX(gdk_pixbuf_get_height(icon_label->icon),
				requisition->height);
    }
}


static void
icon_label_size_allocate(GtkWidget *widget, GtkAllocation *allocation)
{
  IconLabel *icon_label = ICON_LABEL(widget);
  int icon_width = 0;
  int icon_height = 0;
  int y_adjustment = 0;
  int height_adjustment =0;
  if (icon_label->icon != NULL)
    {
      GtkRequisition requisition;
      icon_width = gdk_pixbuf_get_width(icon_label->icon);
      icon_height = gdk_pixbuf_get_height(icon_label->icon);
      
      (*GTK_WIDGET_CLASS(parent_class)->size_request)(widget, &requisition);
      if (requisition.height < icon_height)
	{
	  height_adjustment = icon_height - requisition.height;
	  y_adjustment = height_adjustment / 2;
	  icon_label->icon_y_adjustment = 0;
	}
      else
	{
	  icon_label->icon_y_adjustment
	    = (requisition.height - icon_height) / 2;
	}
    }

  icon_label->fake_allocation.x = allocation->x + icon_width;
  icon_label->fake_allocation.y = allocation->y + y_adjustment;
  icon_label->fake_allocation.width = allocation->width - icon_width;
  icon_label->fake_allocation.height = allocation->height - height_adjustment;
  (*GTK_WIDGET_CLASS(parent_class)->size_allocate)(widget,
						&icon_label->fake_allocation);

  /* Hack: GtkLabelؤ٤αƶǤä*/
  (*GTK_WIDGET_CLASS(parent_parent_class)->size_allocate)(widget, allocation);

}


static int
icon_label_expose(GtkWidget *widget, GdkEventExpose *event)
{
  IconLabel *icon_label = ICON_LABEL(widget);
  GtkAllocation allocation = widget->allocation;

  /* ʪallocationȸGtkLabelʬ褵 */
  widget->allocation = icon_label->fake_allocation;
  (*GTK_WIDGET_CLASS(parent_class)->expose_event)(widget, event);

  /* ᤹ */
  widget->allocation = allocation;

  if (icon_label->icon != NULL
      && GTK_WIDGET_VISIBLE(widget) && GTK_WIDGET_MAPPED(widget))
    {
      /* icon褹롣*/
      gdk_draw_pixbuf(widget->window,
		      widget->style->black_gc,		/* Τ */
		      icon_label->icon,
		      0, 0,				/* src_x, src_y */
		      allocation.x,			/* dst_x */
		      allocation.y + icon_label->icon_y_adjustment, /* dst_y */
		      -1, -1,				/* use pixbuf's size */
		      GDK_RGB_DITHER_NONE,
		      0, 0);
    }

  return FALSE;
}


GtkWidget *
icon_label_new(const gchar *label_text, GdkPixbuf *icon)
{
  GtkWidget *widget = g_object_new(ICON_LABEL_TYPE, "label", label_text, NULL);
  IconLabel *icon_label = ICON_LABEL(widget);

  if (icon != NULL)
    {
      OCHU_OBJECT_REF(G_OBJECT(icon));
      icon_label->icon = icon;
    }

  return widget;
}


void
icon_label_set_icon(IconLabel *icon_label, GdkPixbuf *icon)
{
  g_return_if_fail(IS_ICON_LABEL(icon_label));

  if (icon_label->icon == icon)
    return;

  if (icon_label->icon != NULL)
    OCHU_OBJECT_UNREF(G_OBJECT(icon_label->icon));

  if (icon != NULL)
    OCHU_OBJECT_REF(G_OBJECT(icon));

  icon_label->icon = icon;
  gtk_widget_queue_resize(GTK_WIDGET(icon_label));
}
