/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: text_search_window.h,v 1.4 2003/12/30 21:53:28 fuyu Exp $
 */

#ifndef _TEXT_SEARCH_WINDOW_H_
#define _TEXT_SEARCH_WINDOW_H_

#include "ochusha.h"
#include "ochusha_ui.h"

#include <glib.h>
#include <gtk/gtk.h>


#ifdef __cplusplus
extern "C" {
#endif

#define TEXT_SEARCH_WINDOW_TYPE			(text_search_window_get_type())
#define TEXT_SEARCH_WINDOW(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), TEXT_SEARCH_WINDOW_TYPE, TextSearchWindow))
#define TEXT_SEARCH_WINDOW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), TEXT_SEARCH_WINDOW_TYPE, TextSearchWindowClass))
#define IS_TEXT_SEARCH_WINDOW(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), TEXT_SEARCH_WINDOW_TYPE))
#define IS_TEXT_SEARCH_WINDOW_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), TEXT_SEARCH_WINDOW_TYPE))
#define TEXT_SEARCH_WINDOW_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), TEXT_SEARCH_WINDOW_TYPE, TextSearchWindowClass))


typedef struct _TextSearchWindow TextSearchWindow;
typedef struct _TextSearchWindowClass TextSearchWindowClass;


typedef enum {
  TEXT_SEARCH_DIRECTION_UP,
  TEXT_SEARCH_DIRECTION_DOWN,
} TextSearchDirection;


struct _TextSearchWindow
{
  GtkWindow parent_object;

  /* main_box */
  GtkEntry *entry;

  /* search_option_box */
  GtkToggleButton *match_case_button;
  GtkToggleButton *enable_wrap_button;
  GtkToggleButton *use_regexp_button;

  /* direction_box */
  GtkToggleButton *direction_up_button;
  GtkToggleButton *direction_down_button;

  GtkStatusbar *statusbar;
  guint statusbar_context_id;
  guint statusbar_message_id;


  /* ߤθʤ */
  gchar *key;
  guint direction			: 1;
  guint enable_wrap			: 1;
  guint match_case			: 1;
  guint use_regexp			: 1;

  guint enable_incremental_search	: 1;

  /* ʥȯԤΤ */
  guint query_changed_since_last_search	: 1;
};


struct _TextSearchWindowClass
{
  GtkWindowClass parent_class;

  void (*response)(TextSearchWindow *window, int response_id);
  gboolean (*query_changed)(TextSearchWindow *window, const gchar *key,
			    TextSearchDirection direction,
			    gboolean enable_wrap, gboolean match_case,
			    gboolean use_regexp);
  gboolean (*find_next)(TextSearchWindow *window, const gchar *key,
			TextSearchDirection direction,
			gboolean enable_wrap, gboolean match_case,
			gboolean use_regexp);
};


GType text_search_window_get_type(void) G_GNUC_CONST;
GtkWidget *text_search_window_new(void);

void text_search_window_set_enable_incremental_search(TextSearchWindow *window,
						      gboolean enable);
gboolean text_search_window_get_enable_incremental_search(
						TextSearchWindow *window);

void text_search_window_set_enable_wrap(TextSearchWindow *window,
					gboolean enable);
gboolean text_search_window_get_enable_wrap(TextSearchWindow *window);

void text_search_window_set_match_case(TextSearchWindow *window,
				       gboolean match_case);
gboolean text_search_window_get_match_case(TextSearchWindow *window);

void text_search_window_set_use_regexp(TextSearchWindow *window,
				       gboolean use_regexp);
gboolean text_search_window_get_use_regexp(TextSearchWindow *window);

void text_search_window_response(TextSearchWindow *window, int response_id);

void text_search_window_set_key_selected(TextSearchWindow *window);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _TEXT_SEARCH_WINDOW_H_ */
