/*
 * sql -- example of the variable meta characters. (SQL-like pattern matching)
 */
import onig4j.OnigOptionType;
import onig4j.OnigRegex;
import onig4j.OnigRegion;
import onig4j.OnigSyntaxType;

public class sql {
    public static void main(String[] args) {
        final String pattern = "\\_%\\\\__zz";
        final String str = "a_abcabcabc\\ppzz";
        
        final OnigSyntaxType SQLSyntax = new OnigSyntaxType();
        SQLSyntax.setOperator(OnigSyntaxType.ONIG_SYN_OP_VARIABLE_META_CHARACTERS);
        SQLSyntax.setOptions(OnigOptionType.ONIG_OPTION_MULTILINE);
        SQLSyntax.setMetaChar(OnigSyntaxType.ONIG_META_CHAR_ESCAPE, '\\');
        SQLSyntax.setMetaChar(OnigSyntaxType.ONIG_META_CHAR_ANYCHAR, '_');
        SQLSyntax.setMetaChar(OnigSyntaxType.ONIG_META_CHAR_ANYCHAR_ANYTIME, '%');
 
        final OnigRegex reg = new OnigRegex(pattern, SQLSyntax);
        final OnigRegion region = new OnigRegion();
        final int r = reg.search(str, region);
        if (r >= 0) {
            System.out.printf("match at %d\n", r);
            for (int i = 0; i < region.count(); ++i) {
                System.out.printf("%d: (%d-%d)\n", i, region.begin(i), region.end(i));
            }
        } else if (r == OnigRegex.ONIG_MISMATCH) {
            System.out.println("search fail");
        }
        
        region.close();
        reg.close();
        SQLSyntax.close();
    }
    
    @org.junit.Test
    public void run() {
        sql.main(null);
    }
}
