/**************************************************
opengate server
htmltemplate: module for inserting parameters to html template and seding out

Copyright (C) 2005 Opengate Project Team
Written by Katsuhiko Eguchi, 2005 
Modified by Yoshiaki Watanabe 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include "opengatesrv.h"

/***********************************************************/
/* replace keywords(keys) in file(filename) and send out   */
/* keys[] has the pairs of pre and post string for replace */ 
/***********************************************************/
int htmlTemplate(char* filename, struct html_key* keys)
{
  FILE *fp;
  char buff[BUFFMAXLN];
  int i;

  if((fp=fopen(filename,"r"))==NULL){
    err_msg("ERR at %s#%d: cannot find file %s",__FILE__,__LINE__,filename);
    return 1;
  }

  while(fgets(buff,BUFFMAXLN,fp)!=NULL){

    /* length check */
    if(strlen(buff)>=BUFFMAXLN-1){
      err_msg("ERR at %s#%d: too long line in %s",__FILE__,__LINE__,filename);
    }

    i=0;
    while( strcmp(keys[i].name,"")!=0 ){
      htmlReplace(buff, keys[i].name, keys[i].val);
      i++;
    }
    printf("%s",buff);
  }
  fclose(fp);
  
  return 0;
}

/*****************************************************/
/* replace beforeStr to afterStr in string in buff   */
/*****************************************************/
int htmlReplace(char* buff,char *beforeStr,char *afterStr)
{
  char *pBuff , *pNext;
  char tempBuff[BUFFMAXLN];
  
  if(buff==NULL) return 1;

  strlcpy(tempBuff, buff, BUFFMAXLN);
  strlcpy(buff,"",BUFFMAXLN);
  
  for(pBuff = tempBuff;
      (pNext=strSplit(pBuff, beforeStr)) != NULL;
      pBuff = pNext){
    strlcat(buff,pBuff,BUFFMAXLN);
    strlcat(buff,afterStr,BUFFMAXLN);
  }
  strlcat(buff,pBuff,BUFFMAXLN);
  
  return 0;
}

/*****************************************************/
/* split a str at delimStr and return the point      */
/*****************************************************/
char* strSplit(char* str,const char* delimStr)
{
    char* delimPoint = strstr(str,delimStr);
    const size_t delimLen = strlen(delimStr);

    if(delimPoint == NULL) return NULL;
    else{
        *delimPoint = '\0';
        delimPoint += delimLen; 
    }
    return delimPoint;
}

/**********************************************************/
/**********************************************************/
int HtmlTemplate(char* filename, struct html_key* keys){

  int ret;
  if(debug>1) err_msg("DEBUG:=>htmlTemlate(%s,..)", 
		    filename);
  ret = htmlTemplate(filename,keys);
  if(debug>1) err_msg("DEBUG:(%d)<=htmlTemplate()",ret);
  return ret;
}

int HtmlReplace(char* buff,char *beforeStr,char *afterStr){
  int ret;
  if(debug>1) err_msg("DEBUG:=>htmlReplace(%s,%s,%s)",buff,beforeStr,afterStr);
  ret = htmlReplace(buff, beforeStr, afterStr);
  if(debug>1) err_msg("DEBUG:(%d)<=htmlReplace()",ret);
  return ret;
}
char* StrSplit(char* str,const char* delimStr){
  char* ret;
  if(debug>1) err_msg("DEBUG:=>strSplit(%s,%s)",str,delimStr);
  ret = strSplit(str, delimStr);
  if(debug>1) err_msg("DEBUG:(%s)<=strSplit()",ret);
  return ret;
}

