/**************************************************
opengate server header file

Copyright (C) 1999 Opengate Project Team
Written by Yoshiaki Watanabe
Modfied Katsuhiko Eguchi, 2005 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: watanaby@is.saga-u.ac.jp
**************************************************/

#include	<sys/types.h>	/* basic system data types */
#include	<sys/socket.h>	/* basic socket definitions */
#include	<sys/time.h>	/* timeval{} for select() */
#include	<time.h>	/* timespec{} for pselect() */
#include	<netinet/in.h>	/* sockaddr_in{} and other Internet defns */
#include	<arpa/inet.h>	/* inet(3) functions */
#include	<errno.h>
#include	<fcntl.h>	/* for nonblocking */
#include	<netdb.h>
#include	<signal.h>
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<sys/stat.h>    /* for S_xxx file mode constants */
#include	<sys/uio.h>	/* for iovec{} and readv/writev */
#include	<unistd.h>
#include	<sys/wait.h>
#include	<sys/un.h>      /* for Unix domain sockets */
# include	<sys/select.h>  /* for convenience */
# include	<poll.h>	/* for convenience */
# include	<strings.h>	/* for convenience */
# include	<sys/ioctl.h>
# include	<sys/filio.h>
# include	<sys/sockio.h>
# include	<pthread.h>
#define	SA	struct sockaddr
#define	LISTENQ		1024	/* 2nd argument to listen() */
typedef	void	Sigfunc(int);	/* for signal handlers */

#include <syslog.h>
#include <ctype.h>
#include <stdarg.h>
#include <sys/signal.h>
#include <regex.h>

#include <openssl/crypto.h>
#include <openssl/x509.h>
#include <openssl/pem.h>
#include <openssl/ssl.h>
#include <openssl/err.h>
#include <openssl/md5.h>

/***************** constants ***********************/

/* Configuration file for opengate */ 
#define CONFIGFILE "/etc/opengate/opengatesrv.conf"

#define PAMSERVICENAME "opengate"    /* default service name used in PAM */
#define RADIUSCONF  "/etc/radius.conf" /* default path to radius.conf */

#define COOKIENAME "OpengateAuth"  /* http-cookie name */

#define ADDRMAXLN 128      /* maximum address string length */
#define PASSMAXLN 128      /* maximum password string length */
#define USERMAXLN 128      /* maximum userid string length */
#define BUFFMAXLN 1024      /* maximum buffer string length */
#define WORDMAXLN 64       /* maximum word length */
#define SIDMAXLN 64       /* maximum sessionID length */
#define TRUE 1
#define FALSE 0
#define DENY   0
#define ACCEPT 1

#define NOCONNECT 0    /* the client is not connected yet. */
#define HTTPCONNECT 1  /* the client is connected by HTTP Keep-Alive */
#define ENDCONNECT 2   /* the client is now terminating */
#define DUPLICATED 3   /* the client is duplicated */

#define IPV4ONLY 4
#define IPV46DUAL 46
#define IPV6ONLY 6
#define IPV4 4
#define IPV6 6

struct clientAddr
{
  int ipType;                    /* IP type 4 or 6 */
  char ipAddr[ADDRMAXLN];      /* client IP address */
  char ruleNumber[WORDMAXLN];  /* rule number of ipfw or ip6fw */
  time_t timeIn;               /* start time */
  int activeStatus;             /* active check */
  struct clientAddr * next;    /* next struct */
};

struct html_key{
  char* name;
  char* val;
};

extern int debug;

/**********prototypes***************************************/
/* authentication */
int AuthenticateUser(char *userid, char *password);
char* ConcatUserId(char*  useridfull, char* userId, char* extraId);

/* firewall control */
int OpenClientGate4(char *clientAddr4, char *userid, char *macAddr4, char *userProperty);
int OpenClientGate6(char *clientAddr6, char *userid, char *macAddr6, char *userProperty);
void CloseClientGate4(struct clientAddr *pClientAddr, char *userid, char *macAddr4);
void CloseClientGate6(struct clientAddr *pClientAddr, char *userid, char *macAddr6);
int GetPacketCount(struct clientAddr *pClientAddr);
int GetPacketCount4(char *ruleNumber);
int GetPacketCount6(char *ruleNumber);
int CountRuleNumber4(char *ruleNumber);
int CountRuleNumber6(char *ruleNumber);

int OpenClientGate(char *clientAddr4, char *macAddr4, char *clientAddr6, char *macAddr6, char *userid, char *userProperty, int ipStatus);
void DelIpfwRule(char *ruleNumber);
void DelIp6fwRule(char *ruleNumber);
void RemoveDuplicateRule(int duplicateRule4, int duplicateRule6);

/* ndp and arp control */
void DeleteNdpEntry(char *clientAddr6);
void ScanNdpEntry(struct clientAddr *pClientAddr, char *userid, char *macAddr6, char *userProperty);
int GetMacAddrFromArp(char *clientAddr4, char* macAddr4);
int GetMacAddrFromNdp(char *clientAddr6, char* macAddr6);
void SendQuitClient(void);
struct clientAddr *CreateAddrListItem(char* ipAddr, char *ruleNumber, int ipType);

/* cgi interface */
void GetClientAddr(char *clientAddr);
int GetPostData(char *userid, char *password, char *clientAddr4, int *durationPtr, int *durationEntered,char *language, char *redirectedUrl);
int GetCookieData(char *userid, char *clientAddr4, int *durationPtr, int *durationEntered,char *language, char* closeTime);
int GetAuthCookie(char *cookie, char *userid);
void SplitId(char* userid, char* useridshort, char* extraId);
int CheckReferer(void);
void PutClientDeny(char *clientAddr4, char *language);
void PutClientRetry(char *lang);
void PutClientMsg(char *message);
void PutClientAccept(char *userid, char *sessionId, int port, int pid, char *clientAddr4, char *clientAddr6, int ipStatus, int duration, int durationEntered, char *language, char *cookie, int cookieAuth, char *redirectedUrl);
void split(char content[], char *name[], char *value[], char *next[]);
int GetUserIdFromEnv(char *userid);
int TrimDuration(int duration, int durationEntered);

/* comm-userdb.c */
int SetupSqliteBusyTimeoutValue(void);
int PutSessionBeginToDb(char* cookie, char* userid, 
			char* clientAddr4, char* clientAddr6, 
			char* macAddr4, 
			char* ruleNumber4, char* ruleNumber6,
			int duration, int durationEntered, int cookieAuth, 
			char *language);
int PutSessionEndToDb(char* cookie, char* watchMode);
int FixProcessEndInDb(int pid, char* watchMode);
int GetSessionInfoFromDb(char* cookie, char* userid, char* clientAddr4,
			  char *macAddr, int *duration, int *durationEntered,
			 char *language, char* closeTime);
int GetUserProperty(char *userid, char *userProperty);
int CheckNatInsertion(char* macAddr4, char* macAddr6, char* userid);
int FindDuplicateInDbAndClose(char* clientAddr4, int* redundantRule4, 
			    int* redundantRule6, int* redundantPid );

/* TCP communication with client */
int GetListenPort(void);
int WaitClientConnect(char *userid, char *userProperty, char *sessionId, char *clientAddr4, char *clientAddr6, int duration, char *macAddr4, char *macAddr6, int ipStatus, struct clientAddr *pClientAddr, char *language, int port, int pid, int cookieAuth, char *redirectedUrl);
void WaitHttpClose(struct clientAddr *pClientAddr, char *userid, char *userProperty, char *macAddr4, char *macAddr6, int ipStatus, char *sessionid, int port);

/* utilities */
ssize_t readln(int fd, void *ptr, size_t maxlen);
void Writefmt(int fd, const char *fmt, ...);
ssize_t readlnSSL(SSL *fd, void *vptr, size_t maxlen);
void WritefmtSSL(SSL *fd, const char *fmt, ...);
int Lock(int fd);
int Unlock(int fd);
FILE *Popenl(int rootPriv, const char *type, const char *path, ...);
int Systeml(int roorPriv, const char *path, ...);
int Pclose(FILE *stream);
int isNull(const char *pStr);
char *GetServicePortStr(char *servName);
void CreateSessionId(char *sessionId);
void CreateCookie(char *cookie);
char *md5hex(char *hexdigest, int len, char *str);

void ReFormatMacAddr(char* macAddr4, char* macAddr6);
void GetMacAddr(char *clientAddr4, char *macAddr4, char *clientAddr6, char *macAddr6, int ipStatus);
int CheckIpVersions(char *clientAddr4, char *clientAddr6);
int IsSameMacAddr(char* macAddr4, char* macAddr6);

void err_ret(const char *fmt, ...);
void err_sys(const char *fmt, ...);
void err_dump(const char *fmt, ...);
void err_msg(const char *fmt, ...);
void err_quit(const char *fmt, ...);
void errToSyslog(int i);

int Tcp_connect(const char *host, const char *serv);
char * Sock_ntop_host(const struct sockaddr *sa, socklen_t salen);

int Open(const char *pathname, int oflag, mode_t mode);
int Close(int fd);
pid_t Fork(void);
int Pipe(int *fds);
int Getpeername(int fd, struct sockaddr *sa, socklen_t *salenptr);
int Socket(int family, int type, int protocol);
int Listen(int fd, int backlog);
void * Malloc(size_t size);

char* getenvEx(char* env, int pre, int post);

/* address encode and decode */
int AddrEncode(char encodeAddr[], char dotSepAddr[]);
int AddrDecode(char dotSepAddr[], char encodeAddr[]);

/* htmltemplate.c */
int HtmlTemplate(char* filename,struct html_key* key);
int htmlReplace(char* buff,char *before,char *after);
char* strSplit(char* str,const char* delimStr);

/* get-param.c */
int OpenConfFile(void);
void CloseConfFile(void);
void SetupConfExtra(char *userId, char *extraId);
char *GetConfValue(char *name);
int SelectNextAuthServer(void);
void  InitConf();
int RegExMatch(const char *inStr, const char *regEx, int caseSensitive);
void ResetAuthServerPointer(void);

/* ctrl-alarms.c */
int AddAlarm(char *name, int timeout, int preceding, Sigfunc *func);
int RemoveAlarm(char *name);
int EnableAlarm(void);
int DisableAlarm(void);
void listAlarm(void);

/* udp-client.c */
int PutMacAddressToOpengateMd(char* macAddress);
int PutDataToUdpPort(char* udpServerAddr, char* udpServerPort, char* buff);

/* signal.c */
Sigfunc* signalx(int signo, Sigfunc* func);
