/** @file
 * @brief Call back function for GTK.
 *
 * This file is part of the `Printer Status Utility Type B' program.
 *
 * @author Copyright (C) 2003,2004 EPSON KOWA Corporation
 * @date 2004/02/06
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <string.h>

#include <gtk/gtk.h>

#include "psub_callbacks.h"
#include "psub_interface.h"
#include "psub_support.h"

#include "psub_common.h"
#include "psub_status_proc.h"

void
disp_info (const char *msg)
{
        GtkWidget* widget;

        Gparams.err_w = create_err_dialog ();
        widget = lookup_widget (GTK_WIDGET (Gparams.err_w), "err_dialog_label");
        gtk_label_set_text (GTK_LABEL (widget), msg);
        gtk_widget_show (Gparams.err_w);
}

void
on_ServerSel_button_released           (GtkButton       *button,
                                        gpointer         user_data)
{
        GtkWidget *widget;
        GtkWidget *clist;
        char      *hostname;

        widget = lookup_widget (GTK_WIDGET(button), "PrSel_okbutton");
        gtk_widget_set_sensitive (widget, FALSE);

        /* get hostname of print server. */
        widget = lookup_widget (GTK_WIDGET(button), "Hostname_value");
        hostname = gtk_editable_get_chars (GTK_EDITABLE(widget), (gint) 0, (gint) -1);
        overwrite_Hostname( &Gparams, hostname );

        clist = lookup_widget (GTK_WIDGET(button), "PrSel_clist");

        /* start freeze list view display. */
        gtk_clist_freeze (GTK_CLIST (clist));

        /* clear all clist data. */
        gtk_clist_clear (GTK_CLIST (clist));


        /* set clist data */
        {
                char      **plist;
                char      **comment;
                int         pr_num;
                const char *clist_null_data[] = { "", "" };

                pr_num = open_get_plist( hostname, DAEMON_PORT, &plist, &comment );
                if ( 0 == pr_num ) {
                        disp_info( _("No printer.") );
                } else if ( -1 == pr_num ) {
                        disp_info( _("Server connection error.") );
                } else if ( -2 == pr_num ) {
                        disp_info( _("Printer daemon error.") );
                } else if( 0 > pr_num ){
                        disp_info( _("Printer communication error.") );
                } else {

                        int i;

                        /* cleate clist */
                        for (i = 0; i < pr_num; i++ ) {
                                gtk_clist_append (GTK_CLIST (clist), (char **)clist_null_data );
                                gtk_clist_set_text (GTK_CLIST (clist), i, 0, plist[i]);
                                gtk_clist_set_text (GTK_CLIST (clist), i, 1, comment[i]);
                        }

                        widget = lookup_widget (GTK_WIDGET(button), "PrSel_frame");
                        gtk_widget_show (widget);
                }
        }
        /* unfreeze list view display. */
        gtk_clist_thaw (GTK_CLIST (clist));
}


void
on_PrSel_clist_select_row              (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
        GtkWidget* widget;
        gp_t *gp = &Gparams;
        char *printer;
        char *description;

        /* get printer name */
        widget = lookup_widget (GTK_WIDGET(clist), "PrSel_clist");
        gtk_clist_get_text (GTK_CLIST(widget), row, (gint) 0, &printer);
        gtk_clist_get_text (GTK_CLIST(widget), row, (gint) 1, &description);
        strcpy( gp->Printer_name, printer );
        strcpy( gp->Printer_description, description );

        gtk_widget_set_sensitive (
                lookup_widget (GTK_WIDGET(clist), "PrSel_okbutton"),
                TRUE);
}


void
on_PrSel_clist_unselect_row            (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data)
{
        gtk_widget_set_sensitive (
                lookup_widget (GTK_WIDGET(clist), "PrSel_okbutton"),
                FALSE);
}


void
on_PrSel_okbutton_released             (GtkButton       *button,
                                        gpointer         user_data)
{
        gtk_widget_hide (
                lookup_widget (GTK_WIDGET(button), "PrSelDialog") );
        start_monitor();
}

void
on_PrinterStatusUtilityTypeB_destroy   (GtkObject       *object,
                                        gpointer         user_data)
{
        gtk_main_quit();
}

/* end of file */
