/** @file
 * @brief Call back function for GTK.
 *
 * This file is part of the `Printer Status Utility Type B' program.
 *
 * @author Copyright (C) 2003,2004 EPSON KOWA Corporation
 * @date 2004/02/06
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#include <gtk/gtk.h>

/** POP-UP diealog message window.
 *
 * For error messgae, warning and any information.
 *
 * @param msg Display message string(s).
 */
void
disp_info (const char *msg);

/** Specified hostname.
 *
 * HTTP connect to print server.
 * And get printer list from the printer daemon.
 */
void
on_ServerSel_button_released           (GtkButton       *button,
                                        gpointer         user_data);

/** Selected a printer in printer column-list in the printer select window.
 *
 * OK button active.
 */
void
on_PrSel_clist_select_row              (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

/** Unselected a printer in printer column-list in the printer select window.
 *
 * OK button inactive.
 */
void
on_PrSel_clist_unselect_row            (GtkCList        *clist,
                                        gint             row,
                                        gint             column,
                                        GdkEvent        *event,
                                        gpointer         user_data);

/** Specified printer name.
 *
 * Start printer status monitor polling.
 * And show printer status utility main window.
 */
void
on_PrSel_okbutton_released             (GtkButton       *button,
                                        gpointer         user_data);

/** Close printer status utility main window.
 */
void
on_PrinterStatusUtilityTypeB_destroy   (GtkObject       *object,
                                        gpointer         user_data);

/* end of file */
