/** @file
 * @brief Common define include header file.
 *
 * This file is part of the `Printer Status Utility Type B' program.
 *
 * @author Copyright (C) 2003,2004 EPSON KOWA Corporation
 * @date 2004/02/06
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef PSUB_COMMON_H
#define PSUB_COMMON_H

/** for hostname string size (in Bytes). */
#define MAX_HOSTNAME     256

/** Printer daemon TCP/IP communication port number. */
#define DAEMON_PORT      22223

/** for printer list. */
#define MAX_PRINTER_LIST 32

/** for printer name string size (in Bytes). */
#define MAX_PRINTER_NAME 32

/** for printer description (in Bytes). */
#define MAX_COMMENT_SIZE 64

/** for display message (in Bytes). */
#define MAX_MESSAGE_SIZE 1024

/* Common Define... */
#ifdef  OK
#if   ( OK != 0 )
#error  OK is already defined in another include file.
#endif
#else
#define OK 0
#endif

#ifdef  ERROR
#if   ( ERROR != -1 )
#error  ERROR is already defined in another include file.
#endif
#else
#define ERROR (-1)
#endif

#ifndef FUNCTION
#define FUNCTION
#endif

#ifdef  LOCAL_FUNC
#if   ( LOCAL_FUNC != static )
#error  LOCAL_FUNC is already defined in another include file.
#endif
#else
#define LOCAL_FUNC static
#endif

#endif
/* End of file */
