/** @file
 * @brief Common function for debug.
 *
 * This file is part of the `Printer Status Utility Type B' program.
 *
 * @author Copyright (C) 2003,2004 EPSON KOWA Corporation
 * @date 2004/02/06
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdarg.h>		/* vfprintf() */
#include <stdio.h>
#include <string.h>		/* strcpy() */

#include "psub_debug.h"


/** ɽ٥ξ */
static info_level_ Max_info_level = DEFAULT_INFO_LEVEL;

int shift_info_level(int n)
{
        Max_info_level += n;
        Max_info_level = min(Max_info_level, (info_level_max -1));
        Max_info_level = max(Max_info_level, (info_level_min +1));
        dbgp(dbg, "Max Info Level = %d\n", Max_info_level);
        return Max_info_level;
}


void msgp(info_level_ level, const char* fmt, ...)
{
        if( Out == level ||
            Err == level ||
            level <= Max_info_level ){

                va_list ap;

                const char *pre = "";
                FILE *fp = stderr;

                switch( level ){
                    case Do:				/*  */
                    case Out:	fp = stdout;		break;
                    case Err:	fp = stderr;		break;

                    case Fatal:				/*  */
                    case Critical: pre = "!error: ";    break;
                    case Warning:  pre = "!warning: ";  break;
                    case Info:     pre = "* ";          break;
                    case Detail:			/*  */
                    case Noisy:				/*  */
                    default:                    	break;
                }

                fprintf(fp, "%s", pre);
                va_start(ap, fmt);
                vfprintf(fp, fmt, ap);
                va_end(ap);
        }
}

void dbgp(char * const file, const int line, char * const func, const char* fmt, ...)
{
        if(MYDEBUG){
                va_list ap;
                fprintf(stderr, "%s: %d: %s: ", file, line, func);
                va_start(ap, fmt);
                vfprintf(stderr, fmt, ap);
                va_end(ap);
        }
}

/* end of file */
