/** @file
 * @brief Common function for debug.
 *
 * This file is part of the `Printer Status Utility Type B' program.
 *
 * @author Copyright (C) 2003,2004 EPSON KOWA Corporation
 * @date 2004/02/06
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef PSUB_DEBUG_H
#define PSUB_DEBUG_H

#include <stdarg.h>		/* vfprintf() */

/* 
 * Compile control switchs...
 */
#ifdef  DEBUG
#define MYDEBUG    1
#define DEFAULT_INFO_LEVEL Info
#else
#define MYDEBUG    0
#define DEFAULT_INFO_LEVEL Warning
#endif

/** ѥޥ */
#define ASSERT(expr) { \
    if(!(expr)) { \
        dbgp(dbg, "Assertion failed.\n"); \
        exit(1); \
    } \
}

#define max(a,b) (((a)>(b))?(a):(b))
#define min(a,b) (((a)<(b))?(a):(b))


/** ɽΥ٥ 
 *
 * #msgp() ˤɽ٥롣\n
 * ɽΥ٥ʬƥ̤ˣʬƤ롣
 *
 * -# ν٤ˤɽ٥Ѥ뤿
 *	  (٤ι⤤˵)
 *	- #Fatal,    ̿ !error:
 *	- #Critical,  !error:
 *	- #Warning,  ٹ !warning:    Υǥե
 *	- #Info,      *            ǥХΥǥե
 *	- #Detail,   ܺ
 *	- #Noisy,    ޤɽ뤫! \n
 * \n
 *      - ex) #msgp(#Info,"connect server success.\\n");\n
 *        ̡ * connect server success. \n
 * \n
 * -# Ū˲ɽ뤿μʤȤƻѡ
 *	- #Out = 1, \c stdout ̵
 *	- #Err = 2, \c stderr ̵ \n
 * \n
 *      - ex) #msgp(#Out,"Hello!\\n");\n
 *        ̡ Hello! \n
 * \n
 * -# ǥХ \c stdout ؽФɥ꡼ϽϤʤ\n
 *	Ͼեإ쥯ȤƥǥХ˻ȤȤʤѡ\n
 * \n
 *	- #Do,      \c stdout ؽϡɽ٥#Warning#Infoδ֡ \n
 * \n
 *      - ex) #msgp(#Do,"key %d = %s,  value %d = %s\\n", k, ks, v, vs);\n
 *        ̡ key 1 = GetStatus,  value 4 = Ready
 *
 * @note ͤ #info_level_ξ/¤Ƚ롣
 *	- #info_level_min = 0,	#info_level_ β(ͤޤޤʤ)
 *	- #info_level_max	#info_level_ ξ(ͤޤޤʤ)
 */
typedef enum {
        info_level_min = 0,
        Out = 1,			/* stdout̵ */
        Err = 2,			/* stderr̵ */
        Fatal,			/* ̿ !error:       */
        Critical,			/*  !error:       */
        Warning,			/* ٹ !warning:     */
        Do,				/* stdoutؽ       */
        Info,				/*  !info:        */
        Detail,			/* ܺ               */
        Noisy,			/* ޤΤ餻뤫! */
        info_level_max
} info_level_;


/** ɽ٥ξ岼
 * 
 * #Max_info_level  \a n ʬ岼롣
 *
 * @param n 岼(٥)\n #info_level_ ȡ
 * @retval #Max_info_level ѹη̤֤ͤ
 */
int shift_info_level(int n);


/** å̤˽Ϥ롣
 *
 * #info_level_ Ƥ٥ꤹ롣\n
 * #Max_info_level ʾ \a level ξɽʤ
 *
 * @param level ե᡼٥
 * @param fmt \c printf() Ʊ񼰡
 * @param ... \c printf() Ʊ񼰡
 *
 * @note #Do, #Out, #Err,Τü򤹤뤿ա\n
 * #info_level_ ȡ
 */
void msgp(info_level_ level, const char* fmt, ...);


/* Debug message header */
#define dbg __FILE__,__LINE__,__FUNCTION__

/** ǥХå \c stderr ˽Ϥ
 *
 * ѥ \c define  \c -DDEBUG 
 * ꤵƤʤɽʤ
 *
 * @param file åɽĽΥե̾
 * @param line åɽĽΥ饤ֹ
 * @param func åɽĽδؿ̾
 * @param fmt \c printf() Ʊ񼰡
 * @param ... \c printf() Ʊ񼰡
 *
 * @note Ѥݤ #dbg Ȥ \c printf() Τ褦˻Ѥ롣\n
 * ˤ¹Իɽս꤬Ǥ롣\n
 * \n
 * ex) #dbgp( dbg, "value = %%d \\n", _flex_id ); \n
 * : sry_flex.c: 1477: dup_func: value = 8342 \n
 * \n
 * emacs C-x M-`  tag-jump ᡢν񼰤ˤ\n
 * #MYDEBUG ȡ
 */
void dbgp(char * const file, const int line, char * const func, const char* fmt, ...);

#endif
/* ---------------------------------------------------------------- */
/* end of file            Copyright (C) 2003 EPSON KOWA Corporation */
