/** @file
 * @brief Printer Status Utility Type B.
 *
 * @author Copyright (C) 2003,2004 EPSON KOWA Corporation
 * @date 2004/02/06
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <stdlib.h>
#include <string.h>
#include <locale.h>

#include <gtk/gtk.h>

#include "psub_interface.h"
#include "psub_support.h"

#include "psub_common.h"
#include "psub_status_proc.h"
#include "psub_debug.h"

/*
 * Define and Macros...
 */

#define is_set(s) ((s) && (*s))

int
main (int argc, char *argv[])
{
        GtkWidget *PrinterStatusUtilityTypeB;
        GtkWidget *PrSelDialog;

#ifdef ENABLE_NLS
	setlocale ( LC_ALL, "" );

        bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
        bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
        textdomain (GETTEXT_PACKAGE);
#endif

	Gparams.lang = getenv("LC_MESSAGES");
	if ( !is_set(Gparams.lang) )
		Gparams.lang = getenv("LC_ALL");
	if ( !is_set(Gparams.lang) )
		Gparams.lang = getenv("LANG");
	if ( !is_set(Gparams.lang) )
		Gparams.lang = "C";

	msgp(Info, "set locale %s\n", Gparams.lang);

        gtk_set_locale ();
        gtk_init (&argc, &argv);

        add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");

        /*
         * The following code was added by Glade to create one of each component
         * (except popup menus), just so that you see something after building
         * the project. Delete any components that you don't want shown initially.
         */
        PrinterStatusUtilityTypeB = create_PrinterStatusUtilityTypeB ();
        PrSelDialog = create_PrSelDialog ();

        Gparams.top_w = PrinterStatusUtilityTypeB;
        Gparams.sel_w = PrSelDialog;
        Gparams.err_w = 0;

        init_status_proc(argc, argv);

        gtk_main ();

        end_status_proc();

        return 0;
}

/* end of file */
