/** @file
 * @brief Printer status handling functions.
 *
 * This file is part of the `Printer Status Utility Type B' program.
 *
 * @author Copyright (C) 2003,2004 EPSON KOWA Corporation
 * @date 2004/02/06
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
#ifndef PSUB_STATUS_PROC_H
#define PSUB_STATUS_PROC_H

/** GTK CallBack Function Handle */
typedef struct psub_global_params_tag {

        GtkWidget *top_w;       /**< Main Window */
        GtkWidget *sel_w;       /**< Printer Select Dialog */
        GtkWidget *err_w;       /**< Information message Dialog */

        char *lang;		/**< Display Language */

        char  Hostname[MAX_HOSTNAME]; /**< Do not change until http connecting. */
        char  Printer_name[MAX_PRINTER_NAME];
        char  Printer_description[MAX_COMMENT_SIZE];

        int is_http_opend;      /**< 0:close connection, 1:opend */

        int timeout_handler_id;	/**< GTK polling timeout handle ID for updateStatus() */

} gp_t;

extern gp_t Gparams;		/* define in psub_status_proc.c */


/** Initializer for main.
 *
 * Commandline argument parse,
 * Print server and daemon communication start
 * and set polling interval.
 *
 * @param argc Number of commandline arguments.
 * @param argv Command line arguments.
 */
FUNCTION void init_status_proc(int argc, char **argv);


/** Close print server connection.
  */
FUNCTION void end_status_proc(void);


/** Reflesh the printer status utility main window.
 *
 * Call-back function for GTK.
 *
 * @param  data      User data for GTK.
 * @retval TIMER_ON  Polling continue.
 * @retval TIMER_OFF Stop polling.
 */
FUNCTION gboolean updateStatus( gpointer *data );


/** Printer Status Monitor start.
 *
 * Set polling interval and show main window.
 */
FUNCTION void start_monitor( void );


/** Overwrite Grobal parameters Hostname.
 *
 * If HTTP connection opend, do not overwrite Hostname.
 *
 * @param gp PSUB Global parameters. See #gp_t
 * @param hostname New hostname.
 *
 * @retval -1 ERROR
 * @retval  0 OK
 */
FUNCTION int overwrite_Hostname( gp_t *gp, const char *hostname );


/** HTTP open and get printer list.
 *
 * @param hostname Print server hostname or IP address.
 * @param port     Printer daemon communication port number.
 * @param plist    Printer name pointer list.
 * @param comment  Printer description pointer list.
 *
 * @retval    n number of printers.
 * @retval    0 no printer entry.
 * @retval   -1 Socket Level Communication Error.
 * @retval   -2 HTTP Level Error.
 */
FUNCTION int open_get_plist( const char *hostname, const int port, char ***plist, char ***comment );

#endif
/* End of file */
