//
//	おれんじぺこ コマンドプロセッサ
//
//	とても汚いので将来綺麗にしたい
//
// this file is encoded in utf-8
//

#include <stdio.h>
#include <fcntl.h>
#include <sys/errno.h>
#include <iostream>
#include <string.h>

using namespace std;

static	char	cmdname[256];
static	char	cmdname2[256];
static	char	cmdbuff[128];
static	char	cmdline[128];

static	readdir_t	dirbuff;


char* strchr(const char* s,char c){
	for(;*s!=c&&*s;s++){}
	if(*s==c)
		return (char*)s;
	else
		return NULL;
}


int	_htoi(char c){
	switch(c){
	case '0'...'9':
		return c&0xF;
	case 'A'...'Z':
		return c-55;
	case 'a'...'z':
		return c-87;
	default:
		return -1;
	}
}

static char getsbuff[72+2];
char* _gets(char* s){
	getsbuff[0]=72;
	_dos_get_string(getsbuff);
	getsbuff[2+getsbuff[1]]=0;
	strcpy(s,getsbuff+2);
	return s;
}

string get_err_string(int errno){
	switch(errno>0?errno:-errno){
		case ENOENT:
			return "No such file or directory";
		case EIO:
			return "Input/output error";
		case ENOEXEC:
			return "Exec format error";
		case EBADF:
			return "Bad file descriptor";
		case ENOMEM:
			return "Cannot allocate memory";
		case EACCES:
			return "Permission denied";
		case EFAULT:
			return "Bad address";
		case EBUSY:
			return "Device busy";
		case EINVAL:
			return "Invalid argument";
		case ENFILE:
			return "Too many open files in system";
		case EMFILE:
			return "Too many open files";
		case EROFS:
			return "Read-only filesystem";
		case ENODEV:
			return "Operation not supported by device";
		default:
			return NULL;
	}
}

int main(void){

	{
		uint64	ver=sys_get_version();
		cout<<"OrangePekoe Command Processor version "<<LOBYTE(ver)<<'.'<<HIBYTE(ver)<<'.'<<HIWORD(ver)<<endl;
	}

	for(;;){
begin_cmd:;
		//	プロンプト
		cout<<'['<<(char)('A'+_dos_get_current_drive())<<']';
		_gets(cmdbuff);

		strcpy(cmdline,cmdbuff);
		strcpy(cmdname,strtok(cmdbuff," "));
		string param=strtok(NULL," ");
		if(!param) param="";

		if(!*cmdname){	// null
			;
		}else if(cmdname[0]=='!' && cmdname[1]=='\0'){	//	!
			asm volatile("int $3");
		}else if(cmdname[1]==':' && cmdname[2]=='\0'){	//	x:
			_dos_select_disk((cmdname[0]&0x1F)-1);
		}else if(!strcmp(cmdname,"type")){
			int fd=open(param,O_RDONLY,0);
			if(fd>=0){
				int count;
				char* readbuff=new char[4096];
				while(count=read(fd,readbuff,4096)){
					cout.write(readbuff,count);
				}
				delete readbuff;
				close(fd);
				cout << endl;
			}else{
				cerr << get_err_string(fd) << endl;
			}
		}else if(!strcmp(cmdname,"cd")){
			int err=_dos_chdir(param);
			if(err<0){
				cerr << get_err_string(err) << endl;
			}
		}else if(!strcmp(cmdname,"cls")){
			sys_clearconsole();
		}else if(!strcmp(cmdname,"gcls")){
			sys_ginit();
		}else if(!strcmp(cmdname,"mode")){
			GSSTATUS	gs;
			sys_gs_get_status(&gs);
			string param2=strtok(NULL," ");
			if(param2&&!strcmp(param2,"video"))
				param2=strtok(NULL," ");
			string param3=strtok(NULL," ");
			int p3=param3?atoi(param3):0;
			if(param&&param2){
				if(sys_gs_set_mode(atoi(param),atoi(param2),p3?p3:gs.bpp)){
					cout<<"mode: couldn't connect video server."<<endl;
				}
			}else{
				cout<<"screen mode: "<<gs.width<<'x'<<gs.height<<' '<<gs.bpp<<"bpp,"
					<<(gs.flags&0x10 ? "graphics":"text")
					<<",vram="<<(pvoid)gs.framebuffer<<endl;
			}
		}else if(!strcmp(cmdname,"chcp")){
			cout<<"codepage: "<<sys_nls_get_codepage()<<endl;
		}else if(!strcmp(cmdname,"color")){
			if(param[0]&&param[1]){
				sys_set_color(_htoi(param[0])*0x10+_htoi(param[1]));
			}else{
				sys_set_color(0);
			}
		}else if(!strcmp(cmdname,"dir")){
			//	ここだけDOSから遠くかけ離れてる・・・
			uint32	devid=sys_dosx_get_current_drive_devid();
			uint64	dirid=sys_dosx_get_current_directory_index();
			for(intptr index=0;!sys_fs_read_dir(devid,dirid,index,&dirbuff);index++){
				if(!dirbuff.raw[0])
					break;
				if(dirbuff.raw[0]!=0xE5){
					cout
						<< (dirbuff.attr&0x10 ? 'd':'-' )
						<< (dirbuff.attr&0x20 ? 'a':'-' )
						<< (dirbuff.attr&0x01 ? '-':'w' )
						<< (dirbuff.attr&0x08 ? '-':'r' )
						<< '\t' << dirbuff.size << '\t' << dirbuff.filename << endl;
				}
			}
			volume_info vi;
			int err=sys_fs_ioctl(devid,ioctl_get_information,sizeof(vi),&vi);
			if(err<0){
				cerr << get_err_string(err) << endl;
			}else{
				cout<<'\t'<<vi.records.BytesParRecord*vi.records.nFreeRecords<<" Bytes free"<<endl
					<<'\t'<<vi.records.BytesParRecord*vi.records.nTotalRecords<<" Bytes total"<<endl
					<<endl;
			}
		}else if(!strcmp(cmdname,"ver")){
			uint64	ver=sys_get_version();
			uint	dosver=_dos_get_version();
			cout
				<<"OrangePekoe OS/64 version "<<LOBYTE(ver)<<'.'<<HIBYTE(ver)<<'.'<<HIWORD(ver)<<'.'<<HIDWORD(ver)<<endl
				<<"  Copyright(C)2004 The OrangePekoe project"<<endl
				<<"  Copyright(C)2004 Open Source Software for OrangePekoe"<<endl
				<<"    http://orange-pekoe.64b.org/"<<endl
				<<endl;
		}else if(!strcmp(cmdname,"exit")){
			return 0;
		}else if(!strcmp(cmdname,"mem")){
			cout
				<<"Total Physical Memory:\t"<<(sys_get_memory_status(0)>>20)<<"MB"<<endl
				<<"Paged Pool Available:\t"<<(sys_get_memory_status(1)>>20)<<"MB"<<endl
				<<"System Resource Left:\t"<<(sys_get_memory_status(2)>>10)<<"KB"<<endl
				<<"Current Process:\t"<<(sys_get_memory_status(0x1001)>>10)<<"KB Used/"<<(sys_get_memory_status(0x1000)>>10)<<"KB Allocated"<<endl;
		}else if(!strcmp(cmdname,"uname")){
			bool uname_a = (strchr(param,'a')!=NULL);
			cout
				<<((!*param||uname_a||strchr(param,'s'))?"DOS64 ":"")	//	kernel name
				<<((uname_a||strchr(param,'n'))?"localhost ":"")	//	node
				;
			if(uname_a||strchr(param,'r')){
				uint64	ver=sys_get_version();
				cout<<LOBYTE(ver)<<'.'<<HIBYTE(ver)<<'.'<<HIWORD(ver)<<' ';
			}
			if(uname_a||strchr(param,'v')){
				uint64	ver=sys_get_version();
				cout<<HIDWORD(ver)<<' ';
			}
			cout
				<<((uname_a||strchr(param,'m'))?"x86-64 ":"")		//	machine
				<<((uname_a||strchr(param,'p'))?"unknowncpu ":"")	//	processor
				<<((uname_a||strchr(param,'o'))?"OrangePekoe ":"")	//	os
				<<endl;
		}else{
			int exec_return;
			strcpy(cmdname2,cmdname);
			exec_return = _dos_exec(cmdname2,cmdline);
			switch(exec_return){
			case -ENOENT:
			case -ENOEXEC:
				strcpy(cmdname2,cmdname);
				strcat(cmdname2,".com");
				exec_return = _dos_exec(cmdname2,cmdline);
				break;
			}
			switch(exec_return){
			case -ENOENT:
				strcpy(cmdname2,cmdname);
				strcat(cmdname2,".exe");
				exec_return = _dos_exec(cmdname2,cmdline);
				break;
			}
			if(exec_return>0){
				cerr << "cmd: A program terminated with error code " << exec_return << endl;
			}else if(exec_return<0){
				switch(exec_return){
				case -ENOENT:
					cerr << "Bad command or file name" << endl;
					break;
				default:
					cerr << get_err_string(exec_return) << endl;
				}
			}
		}
	}
}
