#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "snp_Primitive.h"

int main(int argc, char* argv[])
{
    InputPrimitive inputPrimitive={"", "", "", 0, "", 0, 0, 0};

    if(argc != 9){
        printf("[usage]main.exe [InputFile1] [InputFile2] [outputFile] [AreaFileType] [BlockAreaFile] [Score] [Repeat] [dataType] \n");
        return 255;
    }
    strcpy(inputPrimitive.inputFile1, argv[1]);
    strcpy(inputPrimitive.inputFile2, argv[2]);
    strcpy(inputPrimitive.outputFile1, argv[3]);
    inputPrimitive.areaFileType = atoi(argv[4]);
    strcpy(inputPrimitive.blockAreaFile, argv[5]);
    inputPrimitive.score = atoi(argv[6]);
    inputPrimitive.repeat = atol(argv[7]);
    inputPrimitive.dataType = atoi(argv[8]);

    /* XRAvZ@̎w */
    iWay = inputPrimitive.score;

    /* ֐ */
    initMyRand();

    /* PrimitivePermutations */
    MainProgramPrimitive(&inputPrimitive);

}


/* PrimitivePermutations */
void MainProgramPrimitive(InputPrimitive *inputPrimitive)
{
    int retval = 0;
    int flag = 0;
    long i = 0;
	long j = 0;
    long fileLine1 = 0; /* ̓t@C̃C */
    long fileLine2 = 0; /* ̓t@C̃C */
    long areaFileLine = 0; /* haplotypeubN̈wt@C̃C */
    long a = 0;         /* number of haplotype copies (=sequences) in case */
    long b = 0;         /* number of haplotype copies (=sequences) in control */
    long n = 0;
    long dataNum;       /* caseAcontrolf[^̑SNP */
    long jStart = 0;    /* haplotypeubN̍ŏSNP */
    long jEnd = 0;      /* haplotypeubN̍ŌSNP */
    long blockNum = 0;  /* haplotypeubN */
    long repeat = 0;
    long startPos = 0;
    long endPos = 0;
    double S = 0;

    int **T = NULL;             /* 􌻕\ */
    int *populationType = NULL;
    long *blockArea = NULL;     /* ehaplotypeubN̈i[ */
    long *linkSNPNum = NULL;    /* ehaplotypeubNSNP */
    long *linkSNPStart = NULL;  /* ehaplotypeubN̍ŏSNP */
    long *maxScoreIndex = NULL; /* ehaplotypeubÑXRAől̍ */
    long *count = NULL;         /* ehaplotypeubÑXRAől𒴂XRȀo */
    double *Sobs = NULL;        /* ehaplotypeubÑXRAől */

    FILE *fpCase = NULL;    /* ́icasejt@C|C^ */
    FILE *fpCntl = NULL;    /* ́icontroljt@C|C^ */
    FILE *fpOut = NULL;     /* o̓t@C|C^ */
    FILE *fpArea = NULL;    /* haplotypeubN̈wt@C|C^ */

    char *caseData = NULL;      /* Tvf[^icaseji[p */
    char *controlData = NULL;   /* Tvf[^icontrolji[p */

    SnpData *snpTmpData1 = NULL;
    SnpData *snpTmpData2 = NULL;
    SnpData *snpData1 = NULL;
    SnpData *snpData2 = NULL;

    repeat = inputPrimitive->repeat;

    /* t@CI[v */
    retval = InputFileOpen(&fpCase, inputPrimitive->inputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpCntl, inputPrimitive->inputFile2);
    if (retval != 0){
        goto finalize;
    }
    retval = OutputFileOpen(&fpOut, inputPrimitive->outputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpArea, inputPrimitive->blockAreaFile);
    if (retval != 0){
        goto finalize;
    }

/****************************************************************/
/* f[^                                                   */
/****************************************************************/
 
    /* haplotypeubN̈wt@C̃C擾 */
    areaFileLine = DataReaderCountFileLine(fpArea);
    /* haplotypeubN̈i[pz̃m */
    blockArea = (long*)malloc1Dim(sizeof(long), areaFileLine);
    if (NULL == blockArea){ goto finalize; }
    /* t@C|C^擪ɖ߂ */
    fseek(fpArea, 0L, SEEK_SET);
    /* haplotypeubN̈zɎ߂ */
    DataReaderSetHaplotypeBlockArea(fpArea, blockArea);
 
    /* ̓t@C̃C擾 */
    fileLine1 = DataReaderCountFileLine(fpCase);
    fileLine2 = DataReaderCountFileLine(fpCntl);

    /* t@C|C^擪ɖ߂ */
    fseek(fpCase, 0L, SEEK_SET);
    fseek(fpCntl, 0L, SEEK_SET);

    /* f[^ꎞi[p\̂̃m */
    snpTmpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine1);
    snpTmpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine2);

    /* f[^t@Cǂݍݍ\̂Ɏ߂ */
    DataReaderSetAllData(fpCase, snpTmpData1, fileLine1, inputPrimitive->dataType);
    DataReaderSetAllData(fpCntl, snpTmpData2, fileLine2, inputPrimitive->dataType);

    /* ̓f[^̐`FbNĕ񉻗p̓̓f[^쐬 */
    /* MPI_Bcast̉񐔂炷߂ɃTvf[^͕ʔzicaseData, controlDatajŕێ */
    dataNum = DataReaderMakeParallelData(snpTmpData1, snpTmpData2, fileLine1, fileLine2, &snpData1, &snpData2, &caseData, &controlData);

    /* gpȂz̃J */
    /* \SnpDataõJ */
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    snpTmpData1 = NULL;
    snpTmpData2 = NULL;

    /* ̓f[^̃Tv擾 */
    a = snpData1[0].dataNum;
    b = snpData2[0].dataNum;
    n = a + b;

    /* \SnpDataɃTvf[^Rs[ */
    DataReaderDataCopyToSnpData(snpData1, caseData, dataNum, a);
    DataReaderDataCopyToSnpData(snpData2, controlData, dataNum, b);

/****************************************************************/
/* m                                                   */
/****************************************************************/

    /* haplotypeubN */
    if (inputPrimitive->areaFileType == 0){
        blockNum = areaFileLine - 1;
    }
    else {
        /* haplotypeubŇvZ */
        if (blockArea[0] > dataNum){
            blockNum = 1;
            blockArea[1] = dataNum; /* linkSNPNum̒lf[^ɂȂ */
        }
        else{
            blockNum = (dataNum - (blockArea[0] - blockArea[1]) ) / blockArea[1];
        }
    }
    /* ehaplotypeubN̈SNPi[pz̃m */
    linkSNPNum = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPNum){ goto finalize; }
    /* ehaplotypeubN̈̍ŏSNPʊi[pz̃m */
    linkSNPStart = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPStart){ goto finalize; }

    /* ehaplotypeubN̈ɊYSNPf[^ */
    if (inputPrimitive->areaFileType == 0){
        for (i = 0; i < blockNum; i++){ /* Ä̏dꍇl */
            startPos = blockArea[i];
            endPos = blockArea[i+1];
            flag = 0;
            /* ̓f[^̓|WVŃ\[gĂƉ */
            for (j = 0; j < dataNum; j++){
                if (startPos <= snpData1[j].pos){
                    if (snpData1[j].pos < endPos){
                        /* ̈SNPJEg */
                        linkSNPNum[i]++;
                        /* ̈̍ŏSNPʂێ */
                        if (0 == flag ){
                            linkSNPStart[i] = j;
                            flag = 1;
                        }
                    }
                    /* ȍ~ÄɊYf[^͏oȂ̂Ŏ̃ubN𒲂ׂ */
                    else {
                        break;
                    }
                }
            }
        }
    }
    else {
        for (i = 0; i < blockNum; i++){
            linkSNPNum[i] = blockArea[0];
            linkSNPStart[i] = i * blockArea[1];
        }
    }

    /* 􌻕\T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }
    /* populationTypẽm */
    populationType = (int*)malloc1Dim(sizeof(int), a + b);
    if (NULL == populationType) { goto finalize; }
    /* HaplotypeubÑXRAől̍ʂ̃m */
    maxScoreIndex = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == maxScoreIndex) { goto finalize; }
    /* HaplotypeubÑXRAől̃m */
    Sobs = (double*)malloc1Dim(sizeof(double), blockNum);
    if (NULL == Sobs) { goto finalize; }
    /* HaplotypeubÑXRAől𒴂XRȀo񐔂̃m */
    count = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == count) { goto finalize; }

/****************************************************************/
/* 菈                                                     */
/****************************************************************/

    /* haplotypeubNPʂŃ[v */
    jStart = 0;
    for (i = 0; i < blockNum; i++){
        jStart = linkSNPStart[i];
        jEnd = jStart + linkSNPNum[i];
        /* ehaplotypeubNŃ[v */
        for (j = jStart; j < jEnd; j++){
            /* ϑl􌻕\쐬 */
            DataReaderPopulationType(&snpData1[j], &snpData2[j], populationType);
            DataReaderMakeTableDi(&snpData1[j], &snpData2[j], populationType, T);
            /* XRAvZ@XRAvZ0ɂȂĂ܂ꍇ-1Ԃ */
            S = TableCalcScore(T);
            /* őXRA肷 */
            if (S > Sobs[i]){
                Sobs[i] = S;
                maxScoreIndex[i] = j;
            }
        }

        /* PrimitivePermutations */
        if (Sobs[i] > 0.0) {
            count[i] = PrimitiveExecute(snpData1, snpData2, Sobs[i], a, b, jStart, jEnd, repeat);
        }
    }

/****************************************************************/
/* 茋ʏo                                                 */
/****************************************************************/

    fprintf(fpOut, "CaseData    = %s\n", inputPrimitive->inputFile1);
    fprintf(fpOut, "ControlData = %s\n", inputPrimitive->inputFile2);
    fprintf(fpOut, "Repeat      = %ld\n", inputPrimitive->repeat);
    fprintf(fpOut, "BlockArea\tSNPNum\trsNumber\tPosition\tScore\tP\n");
    if (inputPrimitive->areaFileType == 0){
        for (i = 0; i < blockNum; i++){
            if (Sobs[i] != 0){
                fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.10lf\t%.10lf\n", 
                    blockArea[i],
                    blockArea[i+1],
                    linkSNPNum[i],
                    snpData1[ maxScoreIndex[i] ].rsNumber,
                    snpData1[ maxScoreIndex[i] ].pos,
                    Sobs[i],
                    (double)count[i] / repeat);
            }
            else {
                fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                    blockArea[i],
                    blockArea[i+1],
                    linkSNPNum[i]);
            }
        }
    }
    else {
        for (i = 0; i < blockNum; i++){
            if (Sobs[i] != 0){
                fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.10lf\t%.10lf\n", 
                    snpData1[ linkSNPStart[i] ].pos,
                    snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                    linkSNPNum[i],
                    snpData1[ maxScoreIndex[i] ].rsNumber,
                    snpData1[ maxScoreIndex[i] ].pos,
                    Sobs[i],
                    (double)count[i] / repeat);
            }
            else {
                fprintf(fpOut, "%ld-%ld\t%ld\tNoData\n", 
                    snpData1[ linkSNPStart[i] ].pos,
                    snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                    linkSNPNum[i]);
            }
        }
    }

/****************************************************************/
/* I                                                     */
/****************************************************************/

finalize:;
    /* t@CN[Y */
    FileClose(fpCase);
    FileClose(fpCntl);
    FileClose(fpOut);
    FileClose(fpArea);
    /* mۂJ */
    free1Dim(blockArea);
    free1Dim(linkSNPNum);
    free1Dim(linkSNPStart);
    freeInt2Dim(T, ROW);
    free1Dim(populationType);
    free1Dim(maxScoreIndex);
    free1Dim(Sobs);
    free1Dim(count);
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    free1Dim(caseData);
    free1Dim(controlData);
    free1Dim(snpData1);
    free1Dim(snpData2);

    return;
}

/* PrimitivePermutations */
long PrimitiveExecute(SnpData *snpData1, SnpData *snpData2, double Sobs, long a, long b, long jStart, long jEnd, long repeat)
{
    int retval = 0;
    long i = 0;
    long j = 0;
    long n = 0;
    long count = 0;

    double S = 0;
    double Sperm = 0;

    int **Tperm = NULL;             /* 􌻕\ */
    int *omega = NULL;
    int *di = NULL;

    n = a + b;

    /* 􌻕\Tperm̃m */
    Tperm = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == Tperm){ goto finalize; }
    /* omegãm */
    omega = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == omega) { goto finalize; }
    /* dĩm */
    di = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == di) { goto finalize; }

    /* permutation */
    for (i = 0; i < repeat; i++){
        Sperm = 0;
        /* ԂVbt */
        retval = PermutationCalcOmega(n, omega);
        if (retval != 0){
            printf("can not create omega\n");
            return -1;
        }
        /* divZ */
        retval =  PermutationCalcDi(n, a, omega, di);
        if (retval != 0){
            printf("can not create di\n");
            return -1;
        }
        /* haplotypeubN̊eSNPvZ */
        for (j = jStart; j < jEnd; j++){
            /* ϑl􌻕\쐬 */
            DataReaderMakeTableDi(&snpData1[j], &snpData2[j], di, Tperm);
            /* XRAvZ@XRAvZ0ɂȂĂ܂ꍇ-1Ԃ */
            S = TableCalcScore(Tperm);
            /* őXRA肷 */
            if (S > Sperm){
                Sperm = S;
            }
        }
        if (Sperm >= Sobs){
            count++;
        }
    }

finalize:;
    /* mۂJ */
    free1Dim(omega);
    free1Dim(di);
    freeInt2Dim(Tperm, ROW);

    return count;
}
