#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "snp_Primitive.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"


void PrimitiveMain()
{
    int a1 = 66,        /* genotype1, case */
        a2 = 34;        /* genotype2, case */
    int b1 = 90,        /* genotype1, control */
        b2 = 10;        /* gneotype2, control */
    int a = a1 + a2,    /* case ̍v */
        b = b1 + b2,    /* control̍v */
        n = a + b;      /* case,control̍v */

    int *genotype = NULL;       /* `q^ */
    int *type = NULL;           /* case ܂ control */
    int *observerOrder = NULL;  /* ώ@ꂽ */
    int **Tobs = NULL;          /* ϑn쐬􌻕\ */
    double Sobs = 0;            /* ϑl̋􌻕\̃XRA */

    int *omega = NULL;
    int *di = NULL;
    int **T = NULL;
    double S = 0;

    int repeat = 100;           /* permutation̉ */
    int h = 0;
    int i = 0;
    int retval = 0;

    int count = 0;

    /* genotypẽm */
    genotype = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == genotype) { goto finalize; }
    /* typẽm */
    type = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == type) { goto finalize; }
    /* observerOrder̃m */
    observerOrder = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == observerOrder){ goto finalize; }

    for (h = 0; h < n; h++){
        if ( (0 <= h) && (h < a1) ){
            genotype[h] = 1;
            type[h] = 1;
        }
        else if ( (a1 <= h) && (h < a) ){
            genotype[h] = 0;
            type[h] = 1;
        }
        else if ( (a <= h) && (h < a+b1) ){
            genotype[h] = 1;
            type[h] = 0;
        }
        else if ( (a+b1 <= h) && (h < n) ){
            genotype[h] = 0;
            type[h] = 0;
        }
        observerOrder[h] = h;
    }

    /* Tobs̃m */
    Tobs = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == Tobs){ goto finalize; }

    /* ϑl􌻕\쐬 */
    retval = PrimitiveCalcT(type, genotype, Tobs, n);
    if (retval != 0){
        printf("can not create Tobs\n");
        return;
    }

    /* ϑl̋􌻕\̃XRAvZĕ\ */
    Sobs = PrimitiveCalcS(Tobs);
    printf("Observed:\n");
    printf("%f\n", Sobs);

    /* omegãm */
    omega = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == omega) { goto finalize; }
    /* dĩm */
    di = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == di) { goto finalize; }
    /* T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T) { goto finalize; }

    /* permutation */
    printf("Permutation\n");
    for (i = 0; i < repeat; i++){
        retval = PrimitiveCalcOmega(n, omega);
        if (retval != 0){
            printf("can not create omega\n");
            return;
        }
        retval =  PrimitiveCalcDi(n, a, omega, di);
        if (retval != 0){
            printf("can not create di\n");
            return;
        }
        retval = PrimitiveCalcT(di, genotype, T, n);
        if (retval != 0){
            printf("can not create T\n");
            return;
        }
        S = PrimitiveCalcS(T);
        printf("%f\n", S);
    }

finalize:;
    /* mۂJ */
	free1Dim(genotype);
    free1Dim(type);
    free1Dim(observerOrder);
    freeInt2Dim(Tobs, ROW);
    free1Dim(omega);
    free1Dim(di);
    freeInt2Dim(T, ROW);

#ifdef DBG
    //test
    printf("%d\n", getMallocCount());
#endif

    return;
}

/* ԂVbt */
int PrimitiveCalcOmega(int len, int* result)
{
    int *flag = NULL;
    int h = 0;
    int i = 0;
    int x = 0;
    int retval = 0;

    /* flag̃m */
    flag = (int*)malloc1Dim(sizeof(int), len);
    if (NULL == flag) {
        retval = 1;
        goto finalize;
    }

    /* z0ŏ */
    for (i = 0; i < len; i++){
        result[i] = 0;
        flag[i] = 0;
    }

    //srand((unsigned)time(NULL)); 
    /* ԂVbt */
    for (h = 0; h < len; h++){
        x = 1;
        do{
            //x = rand() % len;   /* 0len-1܂ł̗𔭐 */
            x = (int)(ran2(&idum) * len);
            result[h] = x;
        } while(flag[x] > 0);
        flag[x]++;
    }

    /* I */
    retval = 0;

finalize:;
    /* mۂJ */
	free1Dim(flag);

    return retval;
}

/* divZ */
int PrimitiveCalcDi(int n, int a, int *omega, int *result)
{
    int h = 0;
    int i = 0;

    /* z0ŏ */
    for (i = 0; i< n; i++){
        result[i] = 0;
    }

    for (h = 0; h < a; h++){
        result[ omega[h] ]++;   /* 0a-1܂łcaseƂ */
    }

    return 0;
}


/* 􌻕\쐬 */
int PrimitiveCalcT(int *d, int *genotype, int **result, int len)
{
    int h = 0;
    int i = 0;
    int j = 0;

    /* result0ŏ */
    for (i = 0; i < ROW; i++){
        for (j = 0; j < COLUMN; j++){
            result[i][j] = 0;
        }
    }

    /* 􌻕\쐬 */
    for (h = 0; h < len; h++){
        result[ d[h] ][ genotype[h] ]++;
    }

    return 0;
}

/* 􌻕\̃XRAvZ */
double PrimitiveCalcS(int **T)
{
	int a1 = 0, a2 = 0, a = 0;
	int b1 = 0, b2 = 0, b = 0;
	int n1 = 0, n2 = 0, n = 0;
	double val;

	a1 = T[0][0];		a2 = T[0][1];		a = a1 + a2;    /* case */
	b1 = T[1][0];		b2 = T[1][1];		b = b1 + b2;    /* control */
	n1 = a1 + b1;		n2 = a2 + b2;		n = n1 + n2;

	val = (double)n * (a1 * b2 - a2 * b1) * (a1 * b2 - a2 * b1);
	val /= (double)(a * b * n1 * n2);

	return val;
}

/* f[^\ */
void PrimitiveShowVector(int *data, int len)
{
    int h = 0;

    for (h = 0; h < len; h++){
        printf("%d\t", data[h]);
    }
    printf("\n");
}
