#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <time.h>
#include <string.h>

#ifdef Linux
    #include <sys/time.h>
#endif

#include "snp_Permutation.h"
#include "snp_Factorial.h"
#include "snp_Q.h"
#include "snp_G.h"
#include "snp_Table.h"
#include "snp_Primitive.h"
#include "snp_MCMC.h"
#include "snp_Gsampler.h"
#include "snp_Config.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"

/* vg^Cv錾 */
void ExecuteMain(char *fileName);
/* t@CPsǂݍŌvZ */
void MainProgramA(InputData *inputData);
/* t@Cf[^IŕێČvZ */
void MainProgramB(InputData *inputData);
/* ԑp֐ */
double gettimeofdaySec();

int main(int argc, char* argv[])
{
    //int num = 0;
    //char fileName[1024];
    InputData inputData={"", "", "", PRINT_LEVEL, SCORE, REPEAT, ANALYSIS};

    /****************************/
    /* ͂Ŏw肷ꍇ */
    /****************************/
    if(argc != 8){
        printf("[usage]main.exe [InputFile1] [InputFile2] [OutputFile1] [OutputLevel1] [Score] [Repeat] [Analysis]\n");
        return 255;
    }
    strcpy(inputData.inputFile1, argv[1]);
    strcpy(inputData.inputFile2, argv[2]);
    strcpy(inputData.outputFile1, argv[3]);
    inputData.outputLevel = atoi(argv[4]);
    inputData.score = atoi(argv[5]);
    inputData.repeat = atol(argv[6]);
    inputData.analysis = atoi(argv[7]);

    /* XRAvZ@̎w */
    iWay = inputData.score;

    /* t@CPsǂݍŌvZ */
    MainProgramA(&inputData);
    /* t@Cf[^IŕێČvZ */
    //MainProgramB(&inputData);


    /**********************************/
    /* ͂t@Cǂݍޏꍇ */
    /**********************************/
    //if(argc != 2){
    //    printf("[usage]main.exe [InputConfigFile]\n");
    //    return 255;
    //}
    /* ͐ݒt@C擾 */
    //strcpy(fileName, argv[1]);
    /* Cs */
    //ExecuteMain(fileName);


    /**********************/
    /* svOI */
    /**********************/
    //while(1){
    //    printf("\n");
    //    printf("(1)execute MainProgram\n");
    //    printf("(2)execute Gsampler\n");
    //    printf("(3)execute Permutation\n");
    //    printf("(4)execute Q\n");
    //    printf("(5)execute G\n");
    //    printf("(6)execute Table\n");
    //    printf("(7)execute MCMC\n");
    //    printf("(8)execute Primitive\n");
    //    printf("(0)end\n");
    //    printf("select number --> ");
    //    scanf("%d", &num);

    //    switch(num){
    //        case 1:
    //            /* CvOs */
    //            printf("InputConfigFileName -> ");
    //            scanf("%s", fileName);
    //            ExecuteMain(fileName);
    //            break;
    //        case 2:
    //            /* Gsampler eXg */
    //            GsamplerMain();
    //            break;
    //        case 3:
    //            /* Permutation eXg */
    //            PermutationMain();
    //            break;
    //        case 4:
    //            /* Q eXg */
    //            QMain();
    //            break;
    //        case 5:
    //            /* G eXg */
    //            GMain();
    //            break;
    //        case 6:
    //            /* Table eXg */
    //            TableMain();
    //            break;
    //        case 7:
    //            /* MCMC eXg */
    //            MCMCMain();
    //            break;
    //        case 8:
    //            /* Primitive eXg */
    //            PrimitiveMain();
    //            break;
    //        case 0:
    //            exit(0);
    //        default:
    //            break;
    //    }
    //}

    return 0;
}

/* ͂ݒt@CǂݍŎs */
/* ͂Ŏw肷ꍇɂ͎gpȂ */
void ExecuteMain(char *fileName)
{
    InputData inputData={"", "", "", PRINT_LEVEL, SCORE, REPEAT, ANALYSIS};

    /* ͐ݒt@Cp[^擾 */
    DataReaderSetInputData(fileName, &inputData);

    /* XRAvZ@̎w */
    iWay = inputData.score;

    /* t@CPsǂݍŌvZ */
    MainProgramA(&inputData);

    /* t@Cf[^IŕێČvZ */
    //MainProgramB(&inputData);

    return;
}

/* t@CPsǂݍŌvZ */
void MainProgramA(InputData *inputData)
{
    int retval = 0;
    int retval1 = 0;
    int retval2 = 0;

    long i = 0;
    long fileLine1 = 0; /* ̓t@C̃C */
    long fileLine2 = 0;
    long repeat = 0; /* Permutation̎s */

    int **T = NULL;     /* 􌻕\ */
    double Sobs = 0;    /* Score̒l@ϑn */
    int count = 0;

    double Hj = 0;
    double p = 0;
    double F = 0;
    double Pr = 0;

    FILE *fpIn1 = NULL;
    FILE *fpIn2 = NULL;
    FILE *fpOut = NULL;

    HapmapData hapmap1;
    HapmapData hapmap2;
                    
    Table Tbl;
    
    repeat = inputData->repeat;

    /* log e[u쐬 */
    retval = FactorialSetFactorial(SNP_DATA_LEN * 2);

    /* t@CI[v */
    retval = InputFileOpen(&fpIn1, inputData->inputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpIn2, inputData->inputFile2);
    if (retval != 0){
        goto finalize;
    }
    retval = OutputFileOpen(&fpOut, inputData->outputFile1);
    if (retval != 0){
        goto finalize;
    }

    /* ̓t@Ct@Co */
    DataReaderOutputHeader(fpOut, inputData);

    /* 􌻕\T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }

    /* Hapmapf[^Psڂ̓f[^ł͂Ȃ̂Őɓǂݍł */
    retval = DataReaderSetHapmapData(fpIn1, &hapmap1, fileLine1);
    if (retval != 0){ 
        return;
    }
    fileLine1++;
    retval = DataReaderSetHapmapData(fpIn2, &hapmap2, fileLine2);
    if (retval != 0){ 
        return;
    }
    fileLine2++;
    /* ŏ̃[vŌvZsȂ悤Ƀ_~[lݒ */
    hapmap1.pos = -2;
    hapmap2.pos = -1;

    while ( retval1 == 0 || retval2 == 0 ){
        /* Hapmapf[^posrAӏ̈`qł邱ƂmF */
        if (hapmap1.pos == hapmap2.pos) {
            /* QHapmapf[^SNPalleles̏Ԃ`FbNA􌻕\쐬 */
            retval = DataReaderCheckSNPalleles(&hapmap1, &hapmap2, T);
            if (retval != 0){
                printf("%s data incorrect!\n", hapmap1.rsNumber);
            }
            else{
                switch(inputData->analysis){
                    case 0:
                        /* XRAvZ */
                        Sobs = TableCalcScore(T);

                        /* Permutations */
                        count = PermutationExecute(T, Sobs, repeat);

                        /* Permutationł̊mPr(T) */
                        retval = TableMakeTableIntArray(&Tbl, T);
                        Pr = FactorialGetLogCombination(Tbl.verticalSum[0], Tbl.table[0][0]) + 
                            FactorialGetLogCombination(Tbl.verticalSum[1], Tbl.table[0][1]) +
                            FactorialGetLogFactorial(Tbl.horizontalSum[0]) +
                            FactorialGetLogFactorial(Tbl.horizontalSum[1]) -
                            FactorialGetLogFactorial(Tbl.horizontalSum[0] + Tbl.horizontalSum[1]);

                        /* m@ŌvZ */
                        Hj = GGetNumberOfDiInHj(Tbl, Sobs);
                        F = FactorialGetCombination(Tbl.horizontalSum[0] + Tbl.horizontalSum[1], Tbl.horizontalSum[0]);
                        p = Hj/F;

                        /* 茋ʃt@Co */
                        DataReaderOutputResult(inputData->outputLevel, fpOut, &hapmap1, &hapmap2, &Tbl,
                                            Sobs, Pr, Hj, F, p, count, repeat);
                        break;
                    default:
                        break;
                }
            }

            /* Hapmapf[^s\̂Ɏ߂ */
            retval1 = DataReaderSetHapmapData(fpIn1, &hapmap1, fileLine1);
            if (retval1 != 0){ 
                //continue;
            }
            fileLine1++;
            /* Hapmapf[^s\̂Ɏ߂ */
            retval2 = DataReaderSetHapmapData(fpIn2, &hapmap2, fileLine2);
            if (retval2 != 0){ 
                //continue;
            }
            fileLine2++;
        }
        /* Hapmapf[^posvȂꍇÃf[^ǂ */
        else if (hapmap1.pos < hapmap2.pos) {
            /* Hapmapf[^s\̂Ɏ߂ */
            retval1 = DataReaderSetHapmapData(fpIn1, &hapmap1, fileLine1);
            if (retval1 != 0){ 
                continue;
            }
            fileLine1++;
        }
        else if (hapmap1.pos > hapmap2.pos) {
            /* Hapmapf[^s\̂Ɏ߂ */
            retval2 = DataReaderSetHapmapData(fpIn2, &hapmap2, fileLine2);
            if (retval2 != 0){ 
                continue;
            }
            fileLine2++;
        }
    }

finalize:;
    /* t@CN[Y */
    FileClose(fpIn1);
    FileClose(fpIn2);
    FileClose(fpOut);
    /* mۂJ */
    freeInt2Dim(T, ROW);
    /* loge[uNA */
    FactorialDeleteFactorial();
    /* \tablẽJ */
    TableFinalTable(&Tbl);

    return;
}

/* t@Cf[^IŕێČvZ */
void MainProgramB(InputData *inputData)
{
    int retval = 0;

    long i = 0;
    long j = 0;
    long fileLine1 = 0; /* ̓t@C̃C */
    long fileLine2 = 0;
    long repeat = 0; /* Permutation̎s */

    int **T = NULL;     /* 􌻕\ */
    double Sobs = 0;    /* Score̒l ϑn */
    int count = 0;

    double Hj = 0;
    double p = 0;
    double F = 0;
    double Pr = 0;

    FILE *fpIn1 = NULL;
    FILE *fpIn2 = NULL;
    FILE *fpOut = NULL;

    HapmapData *hapmap1 = NULL;
    HapmapData *hapmap2 = NULL;

    Table Tbl;
    
    repeat = inputData->repeat;

    /* log e[u쐬 */
    retval = FactorialSetFactorial(SNP_DATA_LEN * 2);

    /* t@CI[v */
    retval = InputFileOpen(&fpIn1, inputData->inputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpIn2, inputData->inputFile2);
    if (retval != 0){
        goto finalize;
    }
    retval = OutputFileOpen(&fpOut, inputData->outputFile1);
    if (retval != 0){
        goto finalize;
    }
 
    /* ̓t@Ct@Co */
    DataReaderOutputHeader(fpOut, inputData);

    /* 􌻕\T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }

    /* ̓t@C̃C擾 */
    fileLine1 = DataReaderCountFileLine(fpIn1);
    fileLine2 = DataReaderCountFileLine(fpIn2);

    /* t@C|C^擪ɖ߂ */
    fseek(fpIn1, 0L, SEEK_SET);
    fseek(fpIn2, 0L, SEEK_SET);

    /* Hapmapf[^i[p\̂̃m */
    hapmap1 = (HapmapData*)malloc1Dim(sizeof(HapmapData), fileLine1);
    hapmap2 = (HapmapData*)malloc1Dim(sizeof(HapmapData), fileLine2);

    /* Hapmapf[^t@Cǂݍݍ\̂Ɏ߂ */
    DataReaderSetAllHapmapData(fpIn1, hapmap1, fileLine1);
    DataReaderSetAllHapmapData(fpIn2, hapmap2, fileLine2);

    /* mFp@t@Co */
    //DataReaderOutputAllData(fpOut, hapmap1, fileLine1);

    j = 1;
    for (i = 1; i < fileLine1; i++){
        /* Hapmapf[^posrAӏ̈`qł邱ƂmF */
        if (hapmap1[i].pos == hapmap2[j].pos){
            /* QHapmapf[^SNPalleles̏Ԃ`FbNA􌻕\쐬 */
            retval = DataReaderCheckSNPalleles(&hapmap1[i], &hapmap2[i], T);
            if (retval != 0){
                printf("%s data incorrect!\n", hapmap1[i].rsNumber);
            }
            else{
                switch(inputData->analysis){
                    case 0:
                        /* XRAvZ */
                        Sobs = TableCalcScore(T);

                        /* Permutations */
                        count = PermutationExecute(T, Sobs, repeat);

                        /* Permutationł̊mPr(T) */
                        retval = TableMakeTableIntArray(&Tbl, T);
                        Pr = FactorialGetLogCombination(Tbl.verticalSum[0], Tbl.table[0][0]) + 
                            FactorialGetLogCombination(Tbl.verticalSum[1], Tbl.table[0][1]) +
                            FactorialGetLogFactorial(Tbl.horizontalSum[0]) +
                            FactorialGetLogFactorial(Tbl.horizontalSum[1]) -
                            FactorialGetLogFactorial(Tbl.horizontalSum[0] + Tbl.horizontalSum[1]);

                        /* m@ŌvZ */
                        Hj = GGetNumberOfDiInHj(Tbl, Sobs);
                        F = FactorialGetCombination(Tbl.horizontalSum[0] + Tbl.horizontalSum[1], Tbl.horizontalSum[0]);
                        p = Hj/F;

                        /* mFp@t@Co */
                        DataReaderOutputResult(inputData->outputLevel, fpOut, &hapmap1[i], &hapmap2[i], &Tbl,
                                            Sobs, Pr, Hj, F, p, count, repeat);
                        break;
                    default:
                        break;
                }
            }

            /* hapmap2̎̃f[^QƂ */
            j++;
        }
        else if (hapmap1[i].pos < hapmap2[j].pos){
            /* [vJEgŎI i++ ŝŉȂ */
        }
        else if (hapmap1[i].pos > hapmap2[j].pos){
            /* hapmap2̎̃f[^QƂ */
            j++;
        }
    }

finalize:;
    /* t@CN[Y */
    FileClose(fpIn1);
    FileClose(fpIn2);
    FileClose(fpOut);
    /* mۂJ */
    freeInt2Dim(T, ROW);
    free1Dim(hapmap1);
    free1Dim(hapmap2);
    /* loge[uNA */
    FactorialDeleteFactorial();
    /* \tablẽJ */
    TableFinalTable(&Tbl);

    return;
}


#ifdef Linux

/* ԑp֐ */
double gettimeofdaySec()
{
    struct timeval tv;
    gettimeofday(&tv, NULL);
    return tv.tv_sec + (double)tv.tv_usec*1e-6;
}

#endif
