/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.dyna;


import java.util.*;
import javax.swing.text.*;
import javax.swing.text.html.*;
import paraselene.*;
import paraselene.mockup.*;
import paraselene.tag.*;
import paraselene.tag.attr.*;

/**
 * コールバック。
 */
class CallBack extends HTMLEditorKit.ParserCallback {
	private SaxContainer	sax;
	private boolean	script_end = false;

	CallBack( DynamicPage p ) {
		sax = new SaxContainer( p );
	}

	public void handleError(String errorMsg, int pos) {
	}

	public void handleComment( char[] data, int pos) {
		script_end = false;
		sax.addComment( data );
	}

	public void handleText(char[] data, int pos ) {
		if ( script_end ) {
			String	txt = new String( new char[]{ data[0] } );
			Linker.readme.addNote( "scriptタグ直後のテキストから\"" + txt + "\"を除外しました。" );
			char[]	tmp = new char[data.length - 1];
			for ( int i = 1; i < data.length; i++ ) {
				tmp[i - 1] = data[i];
			}
			data = tmp;
		}
		script_end = false;
		sax.addText( data, false );
	}

	private ArrayList<Attribute> getAttr( MutableAttributeSet a ) {
		ArrayList<Attribute>	ret = new ArrayList<Attribute>();
		for ( Enumeration<?> em = a.getAttributeNames(); em.hasMoreElements(); ) {
			Object	key = em.nextElement();
			Object	val = a.getAttribute( key );
			Attribute	attr;
			if ( val == null ) {
				attr = new Attribute( key.toString() );
			}
			else {
				attr = new Attribute( key.toString(), val.toString() );
			}
			ret.add( attr );
		}
		return ret;
	}

	private static final String[] endtag_list = new String[] {
		"iframe", "embed"
	};

	private boolean isEndTagFix( String tag ) {
		for ( int i = 0; i < endtag_list.length; i++ ) {
			if ( endtag_list[i].equalsIgnoreCase( tag ) )	return true;
		}
		return false;
	}

	public void handleSimpleTag(javax.swing.text.html.HTML.Tag t, MutableAttributeSet a, int pos) {
		script_end = false;
		String	tag_name = t.toString();
		try {
			if ( isEndTagFix( tag_name ) ) {
				ArrayList<Attribute>	list = getAttr( a );
				int	cnt = list.size();
				for ( int i = 0; i < cnt; i++ ) {
					Attribute	attr = list.get( i );
					if ( attr.getName().equals( "endtag" ) &&
					attr.getString().equals( "true" ) ) {
						handleEndTag( t, pos );
						return;
					}
				}
				handleStartTag( t, a, pos );
				return;
			}
			sax.addTag( tag_name, getAttr( a ) );
			sax.endTag();
		}
		catch( Exception e ) {
			e.printStackTrace();
		}
	}

	public void handleStartTag(javax.swing.text.html.HTML.Tag t, MutableAttributeSet a, int pos) {
		script_end = false;
		try {
			sax.addTag( t.toString(), getAttr( a ) );
		}
		catch( Exception e ) {
			e.printStackTrace();
		}
	}

	public void handleEndTag(javax.swing.text.html.HTML.Tag t, int pos) {
		sax.endTag();
		script_end = "script".equalsIgnoreCase( t.toString() );
	}

}

