/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.dyna;

import java.io.*;


class InStream extends ByteArrayInputStream {
	private boolean eq( int no, int i ) {
		int	b2 = ((int)buf[no] & 0xff);
		return b2 == i;
	}

	private void bom() {
		if ( eq( 0, 0xef ) && eq( 1, 0xbb ) && eq( 2, 0xbf ) ) {
			skip( 3 );
		}
	}

	InStream( String s ) {
		super( s.getBytes() );
		bom();
	}

	InStream( File f ) throws FileNotFoundException, IOException {
		super( new byte[(int)f.length()] );
		FileInputStream	fis = new FileInputStream( f );
		fis.read( buf );
		fis.close();
		bom();
	}
}

