/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup;


import java.net.*;

import paraselene.*;
import paraselene.tag.*;
import paraselene.tag.attr.*;


class TagSource extends Tag implements Source {
	private static long seq = 0;
	private String val_name;

	String getTagString() {
		return new Text( getFirstTag() ).toString( HTMLPart.StringMode.BODY );
	}

	TagSource( String n, boolean single_f ) {
		super( n, single_f );
		val_name = "tag" + Long.toString( seq );
		seq++;
		if ( seq < 0 )	seq = 0;
	}

	public String getValName() {
		return val_name;
	}

	private String getAttributeSource( Attribute a ) throws TagException {
		String	name = a.getName();
		Text	text = a.get();
		String	val = null;
		if ( text != null )	val = text.toString();

		if ( "name".equals( name ) && val != null ) {
			val = Page.getIndexName( val );
		}

		if ( ColorAttribute.isColor( name ) ) {
			try {
				if ( text != null ) {
					val = new Color( val ).toString();
				}
			}
			catch(Exception e){
				throw new TagException( "色の指定が不正です" );
			}
			StringBuffer	buf = new StringBuffer( "new paraselene.tag.attr.ColorAttribute(" );
			buf = buf.append( Make.escape( name ) );
			buf = buf.append( ",new paraselene.Color(" );
			buf = buf.append( Make.escape( val ) );
			buf = buf.append( "))" );
			return buf.toString();
		}

		boolean	uri_f = URIAttribute.isURI( name );
		if ( !uri_f ) {
			if ( "param".equals( getName() ) ) {
				if ( "value".equalsIgnoreCase( name ) ) {
					Attribute	name_atr = getAttribute( "name" );
					if ( name_atr != null ) {
						String	name_str = name_atr.getString();
						if ( name_str != null ) {
							int	cnt = Param.PARAM_URI.getDataCount();
							for ( int i = 0; i < cnt; i++ ) {
								String	p_name = Param.PARAM_URI.getData( i );
								if ( p_name.equalsIgnoreCase( name_str ) ) {
									uri_f = true;
									break;
								}
							}
						}
					}
				}
			}
		}

		if ( uri_f ) {
			try {
				String	tmp = val.trim();
				if ( tmp.isEmpty() ) {
					val = "#";
					Linker.readme.addNote( "空文字のパスを\"#\"に置換しました" );
				}
				URI	uri = new URI( val );
				val = Linker.readme.resolvePath( uri );
			}
			catch(Exception e){
				throw new TagException( "URI[" + val + "]の指定が不正です" );
			}
			StringBuffer	buf = new StringBuffer( "new paraselene.tag.attr.URIAttribute(" );
			buf = buf.append( Make.escape( name ) );
			buf = buf.append( "," );
			buf = buf.append( val );
			buf = buf.append( ",getCharset())" );
			return buf.toString();
		}

		StringBuffer	buf = new StringBuffer( "new paraselene.tag.attr.Attribute(" );
		buf = buf.append( Make.escape( name ) );
		buf = buf.append( ",");
		buf = buf.append( Make.escape( val ) );
		buf = buf.append( ")" );
		return buf.toString();
	}

	private static String append( String ... s ) {
		StringBuffer	buf = new StringBuffer();
		for ( int i = 0; i < s.length; i++ ) {
			buf = buf.append( s[i] );
		}
		return buf.toString();
	}

	private static boolean orEquals( String s1, String ... s2 ) {
		for ( int i = 0; i < s2.length; i++ ) {
			if ( s1.equals( s2[i] ) )	return true;
		}
		return false;
	}

	public String toSource() {
		StringBuffer	buf = null;
		try {
			String[]	name = TagMap.getSource( this );
			buf = new StringBuffer( name[0] );
			buf = buf.append( " " );
			buf = buf.append( val_name );
			buf = buf.append( "=" );
			buf = buf.append( name[1] );
			buf = buf.append( ";\n" );
			Attribute[]	attr = getAllAttribute();
			if ( attr.length > 0 ) {
				buf = buf.append( val_name );
				buf = buf.append( ".setAttribute(" );
				for ( int i = 0; i < attr.length; i++ ) {
					if ( i > 0 ) {
						buf = buf.append( "," );
					}
					buf = buf.append( getAttributeSource( attr[i] ) );
				}
				buf = buf.append( ");\n" );
			}
			int	cnt = getHTMLPartCount();
			for ( int i = 0; i < cnt; i++ ) {
				Source	src = (Source)getHTMLPart( i );
				buf = buf.append( src.toSource() );
				buf = buf.append( val_name );
				buf = buf.append( ".addHTMLPart(" );
				buf = buf.append( src.getValName() );
				buf = buf.append( ");\n" );
			}
		}
		catch(TagException e) {
			System.err.println( e.getMessage() );
			System.err.println( toString() );
			System.exit( 1 );
		}
		return buf.toString();
	}

	protected Text makeText( String str ) {
		return new TextSource( str );
	}
}

