/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.form;

import paraselene.tag.Attribute;
import paraselene.tag.Tag;
import paraselene.tag.form.Control;

public class Input
extends Control {
    private static final long serialVersionUID = 2L;
    protected Type input_type;

    protected Input(Type t) {
        super("input", true);
        try {
            this.input_type = t;
            this.setAttribute(new Attribute("type", t.str));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Input(Type t, String name) {
        this(t);
        if (name != null) {
            this.setAttribute(new Attribute("name", name));
        }
    }

    @Override
    protected Tag newReplica() {
        return new Input(this.input_type);
    }

    public static Input createHidden(String name, String value) {
        Input inp = new Input(Type.HIDDEN, name);
        inp.setValueString(value);
        return inp;
    }

    public boolean isReadOnly() {
        return Control.Status.READONLY.isSet(this);
    }

    public void setReadOnly(boolean flag) {
        Control.Status.READONLY.set(this, flag);
    }

    @Override
    public void setValueString(String v) {
        if (v == null) {
            v = "";
        }
        super.setValueString(v);
    }

    protected static enum Type {
        TEXT("text"),
        PASSWORD("password"),
        CHECK("checkbox"),
        RADIO("radio"),
        SUBMIT("submit"),
        RESET("reset"),
        IMAGE("image"),
        BUTTON("button"),
        FILE("file"),
        HIDDEN("hidden");

        private static final long serialVersionUID = 1L;
        static final String TYPE = "type";
        String str;

        private Type(String s) {
            this.str = s;
        }
    }
}

