/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup;


import paraselene.*;
import java.io.*;

public class SourceHead {
	private static String head = "";
	private static boolean init_f = false;

	static {
		StringBuilder	buf = new StringBuilder();
		buf = buf.append( "// " );
		buf = buf.append( Version.getTitle() );
		buf = buf.append( " generated this source file." );
		buf = buf.append( LineSeparator.getUse() );
		head = buf.toString();
	}

	public static void init( File f ) throws FileNotFoundException, IOException {
		if ( init_f )	return;
		init_f = true;
		StringBuilder	buf = new StringBuilder( head );
		BufferedReader	br = new BufferedReader(
			new InputStreamReader( new FileInputStream( f ) )
		);
		while( true ) {
			String	line = br.readLine();
			if ( line == null )	break;
			buf = buf.append( line );
			buf = buf.append( LineSeparator.getUse() );
		}
		br.close();
		head = buf.toString();
	}

	public static String getHead( File file ) {
		String[]	part = file.getName().split( "\\." );
		if ( part[part.length - 1].equals( "java" ) ) {
			return head;
		}
		return "";
	}
}

