/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.form;


import paraselene.tag.*;

/**
 * ボタン。
 */
public class Button extends Input {
	private static final long serialVersionUID = 2L;
	private boolean pushed = false;

	/**
	 * ボタンの種類。
	 */
	public enum Type {
		SUBMIT( Input.Type.SUBMIT ),
		RESET( Input.Type.RESET ),
		IMAGE( Input.Type.IMAGE ),
		BUTTON( Input.Type.BUTTON );

		private static final long serialVersionUID = 1L;
		Input.Type	type;
		private Type( Input.Type t ) {
			type = t;
		}
	}

	private Type const_type;

	/**
	 * コンストラクタ。
	 * @param type ボタンの種類。
	 */
	public Button( Type type ) {
		super( type.type );
		const_type = type;
	}

	/**
	 * ボタンの種類の取得。
	 * @return ボタンの種類。
	 */
	public Type getType() {
		return const_type;
	}

	protected Tag newReplica() {
		return copy4Replica( new Button( const_type ) );
	}

	void setPushed( boolean flag ) {
		pushed = flag;
	}

	/**
	 * ボタン押下状態の解除。
	 */
	public void resetClicked() {
		setPushed( false );
	}

	/**
	 * ボタン押下がされたか？
	 * @return true:押下された、false:押下されていない。
	 */
	public boolean isClicked() {
		return pushed;
	}
}

