/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.table;


import java.io.*;
import paraselene.*;
import paraselene.tag.*;

/**
 * カラムを表す。tdタグまたはthタグ。
 */
public class Column extends Tag {
	private static final long serialVersionUID = 2L;
	/**
	 * タイプ。
	 */
	public enum Type {
		/**
		 * テーブルヘッダ。THタグ。
		 */
		HEADER("th"),
		/**
		 * テーブルデータ。TDタグ。
		 */
		DATA("td");

		private static final long serialVersionUID = 1L;
		String str;

		private Type( String s ) {
			str = s;
		}
	}

	private Type	const_type;
	/**
	 * 種別の取得。
	 * @return 種別。
	 */
	public Type getType() {
		return const_type;
	}

	/**
	 * コンストラクタ。
	 * @param type タイプ。
	 */
	public Column( Type type ) {
		super( type.str, false );
		const_type = type;
	}

	protected Tag newReplica() {
		return new Column( const_type );
	}

	private static final String COLSPAN = "colspan";
	private static final String ROWSPAN = "rowspan";

	/**
	 * colspan の値を返します。以下のように動作します。
	 * <ul>
	 * <li>属性値がなければ 1 を返します。
	 * <li>属性値が2未満であれば、属性を削除した後、1 を返します。
	 * <li>上記以外であれば、属性値を返します。
	 * </ul>
	 * @return 値。
	 */
	public int getColspan() {
		Integer	v = getAttributeToInteger( COLSPAN );
		if ( v == null )	return 1;
		int ret = v;
		if ( ret < 1 ) {
			removeAttribute( COLSPAN );
			return 1;
		}
		return ret;
	}

	/**
	 * rowspan の値を返します。以下のように動作します。
	 * <ul>
	 * <li>属性値がなければ 1 を返します。
	 * <li>属性値が2未満であれば、属性を削除した後、1 を返します。
	 * <li>上記以外であれば、属性値を返します。
	 * </ul>
	 * @return 値。
	 */
	public int getRowspan() {
		Integer	v = getAttributeToInteger( ROWSPAN );
		if ( v == null )	return 1;
		int ret = v;
		if ( ret < 1 ) {
			removeAttribute( ROWSPAN );
			return 1;
		}
		return ret;
	}

	/**
	 * colspan の設定。以下のように動作します。
	 * <ul>
	 * <li>属性値が2未満であれば、属性を削除します。
	 * <li>上記以外であれば、属性値を設定します。
	 * </ul>
	 */
	void setColspan( int s ) {
		if ( s < 2 ) {
			removeAttribute( COLSPAN );
		}
		else {
			setAttribute( new Attribute( COLSPAN, s ) );
		}
	}

	/**
	 * rowspan の設定。以下のように動作します。
	 * <ul>
	 * <li>属性値が2未満であれば、属性を削除します。
	 * <li>上記以外であれば、属性値を設定します。
	 * </ul>
	 */
	void setRowspan( int s ) {
		if ( s < 2 ) {
			removeAttribute( ROWSPAN );
		}
		else {
			setAttribute( new Attribute( ROWSPAN, s ) );
		}
	}

	public void write( PrintWriter w, StringMode mode ) {
		int	cnt = getHTMLPartCount();
		if ( cnt == 0 ) {
			addHTMLPart( new Text( " " ) );
		}
		super.write( w, mode );
		if ( cnt == 0 ) {
			removeHTMLPart();
		}
	}
}
