/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ajax.data;

import paraselene.*;
import paraselene.tag.*;
import java.io.*;
import java.util.*;

public class TagData implements Serializable {
	private static final long serialVersionUID = 2L;

	public String	id = "";
	public String	body = "";
	public String[]	cmd = null;

	TagData(){}
	TagData( Tag tag ) {
		this( tag, true );
	}
	TagData( Tag tag, boolean flag ) {
		this.id = tag.getAttributeToString( "id" );
		Page	page = tag.getAssignedPage();
		if ( flag ) {
			int cnt = tag.getHTMLPartCount();
			JsonWriter	w = new JsonWriter();
			for ( int i = 0; i < cnt; i++ ) {
				tag.getHTMLPart( i ).write( w, HTMLPart.StringMode.BODY );
			}
			body = w.toString();
			cmd = new String[]{ page.getOnLoadScript() };
		}
		page.resetOnLoadScript();
	}

	public static TagData[] getTag( Page p ) {
		ArrayList<TagData>	list = new ArrayList<TagData>();
		Tag[]	tag = p.getModifiedTag();
		for ( int i = 0; i < tag.length; i++ ) {
			list.add( new TagData( tag[i] ) );
		}
		return list.toArray( new TagData[0] );
	}
}

