// Paraselene 2.1.1.16 (http://paraselene.sourceforge.jp/) generated this source file.
/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup.output.source;
public class SuperPage extends paraselene.mockup.Output {
protected String getFileByte() { return
"package #1;\n\n\nimport #1.#x.*;\nimport paraselene.*;\nimport paraselene.supervisor.*;\nimport paraselene.tag.*;\nimport paraselene.tag.form.*;\nimport paraselene.tag.list.*;\nimport paraselene.tag.table.*;\nimport paraselene.dyna.*;\n\n/**\n * サイトページ基底クラス。\n * 全てのページの共通メソッドを持たせたい場合にはこのクラスに記述できます。\n */\npublic abstract class SuperPage extends Page {\n	/**\n	 * name 属性の検証。\n	 * @param page 検証するページ\n	 * @param exclude 検証から除外する name。\n	 * @return エラーとなった name。\n	 */\n	public abstract NameDefine[] inspectName( Page page, String ... exclude );\n	/**\n	 * 入力値の検証メイン処理。\n	 * @param req リクエスト内容。\n	 * @param fw デフォルト遷移先。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public abstract Forward inputMain( RequestParameter req, Forward fw ) throws PageException;\n	/**\n	 * 出力情報の設定メイン処理。\n	 * @param from 遷移元ページ。\n	 * @param req リクエスト内容。\n	 * @return 出力ページ。\n	 * nullを返すとthisをリターンしたのと同じ扱いにされます。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public abstract Page outputMain( Page from, RequestParameter req ) throws PageException;\n	/**\n	 * 初回outputの呼び出しメイン処理。\n	 * @param req リクエスト内容。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public abstract void firstOutputMain( RequestParameter req ) throws PageException;\n\n	/**\n	 * コンストラクタ。\n	 */\n	public SuperPage() {\n		super();\n	}\n\n	/**\n	 * 出力文字コード。\n	 * @return #2\n	 */\n	public String getCharset() {\n		// 各ページで、出力文字コードを変更したい場合はオーバーライド\n		// して下さい。\n		// または、下記を直接書き換えて下さい。\n		return \"#2\";\n	}\n\n	/**\n	 * 出力コンテントタイプ。\n	 * nullを返すと自動選定されます。選定方法は以下です。\n	 * isXML()がtrueを返し、且つ\n	 * （リクエストヘッダAcceptに application/xhtml+xml が明示されている、\n	 * または携帯からのアクセスである）場合に\n	 * application/xhtml+xml を返します。それ以外では text/html を返します。\n	 * またその時、getCharset()の戻り値を charset に指定します。\n	 * @return null。\n	 */\n	public String getContentType() {\n		// 各ページで、コンテキストタイプを変更したい場合はオーバーライド\n		// して下さい。\n		return null;\n	}\n\n	/**\n	 * 履歴追加方法。\n	 * 過去に同一ページがあれば、直近からそのページまでの履歴をクリアする。\n	 * trueならクリア、falseなら維持する。\n	 * @return true\n	 */\n	public boolean isHistoryClear() {\n		// 各ページで、履歴クリアをしたくない場合にはオーバーライドして\n		// falseを返して下さい。\n		return true;\n	}\n\n	/**\n	 * 履歴追加許可。\n	 * @return true\n	 */\n	public boolean isAllowHistoryAdd() {\n		// 各ページで、履歴に追加したくない場合にはオーバーライドして\n		// falseを返して下さい。\n		return true;\n	}\n\n	/**\n	 * アップロードファイルの最大バイト数。\n	 * @return 負数なら無制限に受け付けます。\n	 */\n	public int getUploadMaxBytes() {\n		// アップロードに制限をかける場合は下記を修正するか、\n		// 各ページでオーバーライドして下さい。\n		// ここでは2Mバイトを上限としています。\n		return 1024 * 1024 * 2;\n	}\n\n	/**\n	 * 処理済みリクエストの再呼び出しを検出するか？\n	 * このページに遷移するためのURIを生成する際のリクエストID付与を\n	 * コントロールします。trueを返すとリクエストIDが付与されます。\n	 * @return true:検出する、false:検出しない。\n	 */\n	public boolean isCheckRepeatSameRequest() {\n		// 各ページで、処理済みリクエストの再呼び出しを検出したい場合には\n		// オーバーライドしてtrueを返して下さい。\n		return false;\n	}\n\n	/**\n	 * 初期化。\n	 */\n	public void init() {\n		// 全ページ共通の初期化処理があれば記述して下さい。\n	}\n\n	/**\n	 * AJAXサポート機能の指定。\n	 * アクセス元が携帯である場合は、この戻り値が何であっても無効になります。\n	 * これ自体か、各ページでオーバーライドしてサポートされたい機能を指定して下さい。\n	 * @return AJAXサポート。\n	 */\n	public AjaxSupport getAjaxSupport() {\n		return AjaxSupport.NO;\n	}\n\n	/**\n	 * 入力値の検証を行う。\n	 * このメソッドが呼ばれる際には必ずセッションが発生しています。\n	 * 入力値のエラーチェックや入力値に即した動作を記述します。\n	 * @param req リクエスト内容。\n	 * @param fw デフォルト遷移先。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public final Forward input( RequestParameter req, Forward fw ) throws PageException {\n		// 共通処理等あれば記述して下さい。\n		return inputMain( req, fw );\n	}\n\n	/**\n	 * 初回outputの呼び出し直前にコールされます。初期化処理を記述します。\n	 * @param req リクエスト内容。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public final void firstOutput( RequestParameter req ) throws PageException {\n		// 共通処理等あれば記述して下さい。\n		firstOutputMain( req );\n	}\n\n	/**\n	 * 出力情報の設定を行う。\n	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。\n	 * @param req リクエスト内容。\n	 * @return 出力ページ。\n	 * nullを返すとthisをリターンしたのと同じ扱いにされます。\n	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。\n	 */\n	public final Page output( Page from, RequestParameter req ) throws PageException {\n		// 共通処理等あれば記述して下さい。\n		return outputMain( from, req );\n	}\n}\n\n";}
}
