/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.mockup;

import paraselene.*;

class TextSource extends Text implements Source {
	private static long seq = 0;
	private String val;

	TextSource( String txt ) {
		super( txt );
		val = "text" + Long.toString( seq );
		seq++;
		if ( seq < 0 )	seq = 0;
	}

	public String toSource() {
		StringBuilder	buf = new StringBuilder( "Text " );
		buf = buf.append( val );
		buf = buf.append( "=new Text(" );
		buf = buf.append( Make.escape( toString() ) );
		buf = buf.append( ");\n" );
		return buf.toString();
	}

	public String getValName() {
		return val;
	}
}

