package #1.#x;

import javax.servlet.http.*;
import paraselene.*;
import paraselene.supervisor.*;
import paraselene.ajax.*;
import paraselene.tag.*;
import paraselene.tag.form.*;
import paraselene.dyna.*;

/**
 * AJAX の Form通信。
 */
public class FormJson extends #1.SuperPage {
	private static final long serialVersionUID = 1L;
	private boolean opera_f = false;
	private Tag	script = new Tag( "script", false );

	/**
	 * コンストラクタ。
	 */
	public FormJson() {
		super();
		init();
		script.setAttribute( new Attribute( "type", "text/javascript" ) );
	}

	/**
	 * 初期化。
	 */
	public void init(){
		clear();
		try {
			Tag	html = new Tag( "html", false );
			Tag	head = new Tag( "head", false );
			head.addHTMLPart( script );
			Tag	body = new Tag( "body", false );
			body.addHTMLPart( new Tag( "iframe", false ) );
			html.addHTMLPart( head, body );
			setMainTag( html );
			setDoctype( false, null );
			super.init();
			setInitialized( true );
		}
		catch( Exception e ) {
			Option.debug( e );
		}
	}

	/**
	 * ページIDの取得。
	 * @return ページID。
	 */
	public PageID getID() {
		return PageType.PARASELENE_FORM_JSON;
	}

	/**
	 * 別名URI設定。nullを返すと別名は設定しません。
	 * @return URI。
	 */
	public String getAliasURI() {
		return null;
	}

	/**
	 * ブラウザに403を返す。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Forward inputMain( RequestParameter req, Forward fw ) throws PageException {
		return new Forward( 403 );
	}

	public boolean isHistoryClear() { return false; }
	public boolean isAllowHistoryAdd() { return false; }
	public String getCharset() { return "UTF-8"; }

	/**
	 * キャッシュ禁止指定。
	 * @return true:ブラウザキャッシュを禁止します。
	 */
	public boolean isNoCache() { return true; }

	/**
	 * 初回outputの呼び出しメイン処理。
	 * @param req リクエスト内容。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public void firstOutputMain( RequestParameter req ) throws PageException {
	}

	/**
	 * 出力情報の設定を行う。
	 * @param from 遷移元ページ。直接呼ばれている場合はnullです。
	 * @param req リクエスト内容。
	 * @return 出力ページ。
	 * @exception PageException 処理の継続が不可能(ブラウザには500を返す)。
	 */
	public Page outputMain( Page from, RequestParameter req ) throws PageException {
		String[]	ua = req.getHeader( "User-Agent" );
		boolean	opera_f = false;
		if ( ua != null ) {
			opera_f = ua[0].indexOf( "Opera" ) != -1;
		}

		StringBuilder	buf = new StringBuilder();
		if ( opera_f ) {
			buf = buf.append( "parent.paraselene_form_ok('" );
			buf = buf.append( from.getUniqueKey() );
			buf = buf.append( "');" );
		}
		else {
			HttpSession	session = req.getSession();
			JSON	data = Ajax.get( session, from.getUniqueKey() );
			buf = buf.append( "if(parent.paraselene_called_form){" );
			buf = buf.append( "parent.paraselene_called_form.target='_self';" );
			buf = buf.append( "parent.paraselene_called_form=undefined;" );
			buf = buf.append( "parent.paraselene_action(" );
			buf = buf.append( data.toString() );
			buf = buf.append( ");}else{history.forward();}" );
		}
		script.removeHTMLPart();
		script.addHTMLPart( new paraselene.ajax.data.JavaScript( buf.toString() ) );
		return this;
	}
	public NameDefine[] inspectName( Page page, String ... exclude ){ return null;}
}

