/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;


import java.io.*;
import java.util.*;

/**
 * ブラウザからのリクエストクエリの１項目。
 */
public class RequestItem implements Serializable {
	private static final long serialVersionUID = 2L;
	String	key;
	ArrayList<String>	value = new ArrayList<String>();
	ArrayList<File>		file = new ArrayList<File>();
	ArrayList<String>	mime = new ArrayList<String>();
	ArrayList<Boolean>	file_flg = new ArrayList<Boolean>();

	/**
	 * クエリ内容の比較。
	 * @param o 比較対象。
	 * @return true:同一リクエスト、false:異なるリクエスト。
	 */
	public boolean equals( Object o ) {
		if ( !(o instanceof RequestItem) )	return false;
		RequestItem	r = (RequestItem)o;
		if ( !key.equals( r.key ) )	return false;
		int	cnt = value.size();
		if ( cnt != r.value.size() )	return false;
		for ( int i = 0; i < cnt; i++ ) {
			if ( !value.get( i ).equals( r.value.get( i ) ) )	return false;
		}
		return true;
	}

	private RequestItem(){}
	RequestItem( String k ) {
		key = k;
	}

	/**
	 * 格納数の取得。
	 * @return 格納数。
	 */
	public int getCount() {
		return file_flg.size();
	}

	/**
	 * キーの取得。
	 * @return キー。
	 */
	public String getKey() {
		return key;
	}

	/**
	 * 設定値またはファイル名の取得。
	 * @param no 0～getCount()-1
	 * @return 設定値。
	 */
	public String getValue( int no ) {
		return value.get( no );
	}

	/**
	 * 設定値またはファイル名の取得。
	 * getValue( 0 ) と等価です。
	 * @return 設定値。
	 */
	public String getValue() {
		return getValue( 0 );
	}

	/**
	 * 設定値またはファイル名の取得。全ての設定値を配列にして返します。
	 * @return 設定値。
	 */
	public String[] getAllValue() {
		return value.toArray( new String[0] );
	}

	/**
	 * ファイルであるか？
	 * @param no 0～getCount()-1
	 * @return true:ファイル、false:通常文字列
	 */
	public boolean isFile( int no ) {
		return file_flg.get( no );
	}

	/**
	 * ファイル取得。
	 * @param no 0～getCount()-1
	 * @return ファイル。
	 */
	public File getFile( int no ) {
		return file.get( no );
	}
	
	/**
	 * コンテントタイプの取得。
	 * @param no 0～getCount()-1
	 * @return コンテントタイプ。
	 */
	public String getContentType( int no ) {
		return mime.get( no );
	}

}

