#include <windows.h>
#include <stdio.h>
#include "SyncList.h"


static void generator(SyncList<int> *a)
{
  int i;
  SyncList<int> *current, *nxt;
  current = a;

  for(i = 0; i < 10; i++){
    current->write(i);
    pards_errorf(INFO, "write:value = %d",i);
    nxt = new SyncList<int>;
    current->writecdr(nxt);
    current = nxt;
    SleepEx(1000,FALSE);
  }
  current->write(i);
  pards_errorf(INFO, "writer:value = %d",i);
  current->writecdr(0);
}

static void consumer(SyncList<int> *a)
{
  SyncList<int> *current,*prev;
  current = a;

  while(1){
	pards_errorf(INFO, "reader:value = %d",current->read());
    prev = current;
    current = current->readcdr();
    delete prev;
    if(current == 0) break;
  }
}

int listsample()
{
  void generator(SyncList<int>*);
  void consumer(SyncList<int>*);
  pards_init();

  SyncList<int> *a;
  a = new SyncList<int>;

  SPAWN(generator(a));
  consumer(a);

  pards_finalize();
  return 0;
}