#include <stdio.h>
#include "parblock.h"

#define NP 3

int spmdsample()
{
  pards_init();

  int *a = (int*)pards_shmalloc(100*NP*sizeof(int));
  int *out = (int*)pards_shmalloc(NP*sizeof(int));

  for(int i = 0; i < 100 * NP; i++)
    a[i] = 1;

  PBInfo* pbi = pards_begin_parallel(NP);

  int pno = pbi->getpno();

  printf("process no. = %d\n",pno);

  int *my_part = a + 100 * pno;
  int sum = 0;

  for(int i = 0; i < 100; i++)
    sum+=my_part[i];

  out[pno] = sum;

  pards_barrier(pbi);

  int totalsum = 0;
  if(pno == 0){
    for(int i = 0; i < NP; i++)
      totalsum += out[i];
  }

  pards_end_parallel(pbi);

  printf("total = %d\n",totalsum);

  pards_finalize();

  return 0;
}