#ifndef PARBLOCK_H
#define PARBLOCK_H

#include "libpards.h"

#ifdef PARDS_USE_EXCEPTION
#include "PardsException.h"
#endif

class PBInfo {
 private:
  int pno; // process no (0..n)
  int *children; // pids of child processes; 1st item is no. of child processes
  int *barrier_count;
  int barrier_write_sem_id;
  int barrier_block_sem_id;
 public:
  PBInfo(int pn, int* ch, int* cnt, int wid, int bid){
    pno = pn;
    children = ch;
    barrier_count = cnt;
    barrier_write_sem_id = wid;
    barrier_block_sem_id = bid;
  }
  void free();
  int getpno(){return pno;}
  void join();
  void barrier();
};

PBInfo* pards_begin_parallel(int);
void pards_end_parallel(PBInfo*);
void pards_barrier(PBInfo*);

#endif
